.TH [%s PRG_NAME] [%d MANUAL_NUMBER] [%s DATE_OF_LAST_MOD] "Version [%s VERSION_NUMBER]" "[%s MANUAL_SECTION_STR]"

.SH NAME
[%s prg_name] \- binary -> ascii (hexadecimal) conversion

.SH SYNOPSIS
.B [%s prg_name]
.RB [ -hrvV ]
.RB [ -b\ bytes ]
.RB [ -n\ bytes ]
.RB [ -o\ offset ]
.RB [ -s\ type ]
.RI [ in-file [ out-file ] ]

.SH DESCRIPTION
.I [%s Prg_name]
converts a binary stream into an ascii stream of hexadecimal numbers and
characters. The input and output defaults to stdin and stdout, respectively.
The output format may be slightly changed by specifying the
.B -b
or the
.B -s
option, see below.

.SH OPTIONS
.TP
.B -h
display some helpful information on [%s HELP_CHANNEL_STR] and exit successfully
.TP
.B -r
display offsets relative to the offset specified with
.BR -o .
.TP
.B -v
be more talkative on [%s VERBOSE_CHANNEL_STR]
.TP
.B -V
display version and compilation settings on [%s VERSION_CHANNEL_STR] and exit successfully
.TP
.BI "\-b " bytes
output
.I bytes
bytes per line (default is [%d DEFAULT_NBPL])
.TP
.BI "\-n " bytes
process
.I bytes
bytes (default is until EOF)
.TP
.BI "\-o " offset
start conversion at offset
.I offset
of input
.TP
.BI "\-s " type
switch on/off display of type
.IR type ,
which may be a mixture of
.I a
(asciis),
.I n
(numbers) and
.I o
(offsets).

.SH RETURN VALUE
On  success, [%d RETVAL_OK] is returned. On error, the return value will
be >[%d RETVAL_OK].

.SH ERRORS
.TP
.B [%d RETVAL_BUG]
a program bug has seen the light. If this should happen, please send
the command line to the address below.
.TP
.B [%d RETVAL_ERROR]
the error is different from those explained above

.SH AUTHOR
[%s MY_EMAIL_ADDRESS]

.SH SEE ALSO
.BR [%s undump_name] (1),
.BR hexdump (1),
.BR od (1),
.BR diskdump (1),
.BR xxd (1)
