$ParseWWW = 1;
$ParseType = "WWW";
$ActLogId = $LogIdWWW;
$EdsFile = "$LogDirEDS/eds.$AccountingDate.$LogHost.$ParseType";
&ParseLogFileWWW ($Log);
&PrintStatistik;

sub ParseLogFile
{
	my ($File) = @_;
	
	print "Reading $LogFile...\n" if $Verbose;

	open (FILE, $File) || die "Error: $File - $!\n";

	#
	# loop thru file looking for lines to process
	#
	while (<FILE>) 
	{
		chop;
		tr/[A-Z]/[a-z]/;

		# Parse the line and extract the data. Format of one line:
		# 	195.41.10.200 - - [02/Dec/1995:08:03:56 +0100] "GET http://bvp.wdp.com/media/
		#	BVMoviePlex/DeadPresidents/Movies/DP310030N.gif HTTP/1.0" 200 4051
		#
		if (/(.*) - - \[(..)\/(...)\/(....):(..:..:..) +(.*)\] "get http:\/\/(.*)" (.*)/) {
			$Year = $4;
			$Year = substr ($Year, 2);
			$Month = $3;
			$Day = $2;
			$Time = $5;
			$From = $1;
			$ToAll = $7;

			#
			# Now we check the LOGFORMAT (Common or Extendent)
			#
			@rest = split(/ /,$8);
			$Size = $rest[1];
			$Size = 0 if ($Size eq "-");
				
			#
			# 1st line: extended log  2nd line: common log
			#
			if (($rest[2] eq "200") ||  				
				(($rest[0] eq "200") && ( $#rest == 1))) 
			{
				$Cache = "N";						
			}
			elsif ($rest[2] eq "304")
			{
				$Cache = "C";
			}
			else
			{
				$Cache = "F";
			}

			#
			# Extract only the host
			#
			@ToAll = split (/\//, $ToAll);
			$Url = $ToAll[0];
			# Port noch entfernen
			if ($Url =~ /:/ ) {
				@Url = split (/:/, $Url);
				$Url = $Url[0];
			}
				
			#
			# Time YYMMDDHHMMSS						
			#
			$Time =~ s/://g;
			$Date = sprintf ("%02d%02d%02d%s", $Year,$MonthNum{$Month}, $Day, $Time);
			
			#
			# Sum everything for statistik
			#
			$Size = int($Size);

			#
			# print the line 
			#
			printf ("%s:%s:%s:%s:%s\n", $From, $LogIdWWW, $Size, $Date, $Url);
		}		
	}
	close (LOG);
}
