#!/usr/local/bin/perl
#
# proxy-summary.pl v1.00 19961002 12:00:00 Iain Lea (iain@sbs.de)
#
# Parse pstats output and access log to create neato HTML statistics

require 'getopts.pl';

$SumFile = $LogFile = '';
$TopN = 25;
$PortNum = 81;
$NoCruft = 0;
$ImgDir = '/img';
$HostName = `hostname`;
chop ($GenDate = `date +%Y%m%d`);
$Verbose = 0;

$TmpDir = "/var/adm";
$MaxHeight = 250;
$Url = 'http://www.sbs.de/~iain/squid-stats/';
$ScriptName = 'proxy-stats';
$Version = 'v1.0';
$TotalRequests = 0;
@HalfHours = 0;
$BegTime = "";
$EndTime = "";


&ParseCmdLine ($0);

&InitReqsPerHalfHour;

&ParseSumFile ($SumFile);

&ParseLogFile ($LogFile);

&GenerateHtmlFile;

exit 0;

##############################################################################
# 
#

sub ParseCmdLine
{
	my ($ProgName) = @_;
	
	&Getopts('cd:hl:m:n:p:s:v');

	if ($opt_h) { 
		print <<EOT
Create HTML statistics from Netscape proxy pstats log and access log.
Copyright 1996 Iain Lea (iain\@sbs.de).    NOTE: Use at your own risk.

Usage: $ProgName [options]
       -h       help
       -c       don't print images or /cgi-bin/ URL's in Top $TopN listings
       -d date  date to gather statistics in YYYYMMDD (default: $GenDate)
       -l file  access log file
       -m host  hostname to use in html
       -n num   number of URL's to list     
       -p num   port number (default: $PortNum)
       -s file  pstats summary file
       -v       verbose

EOT
;
		exit 1;
	}
	$NoCruft = 1 if (defined($opt_c));
	$GenDate = $opt_d if (defined($opt_d));
	$LogFile = $opt_l if (defined($opt_l));
	$HostName = $opt_m if (defined($opt_m));
	$TopN = $opt_n if (defined($opt_n));
	$PortNum = $opt_p if (defined($opt_p));
	$SumFile = $opt_s if (defined($opt_s));
	$Verbose++ if (defined($opt_v));

	die "Error: $LogFile - $!\n" if ($LogFile eq '');
	die "Error: $SumFile - $!\n" if ($SumFile eq '');
}

sub ParseSumFile
{
	my ($File) = @_;
	my ($TableNum) = 0;
	my ($Num) = 0;

	print STDERR "Parsing $File ...\n";
		
	open (FILE, "$File") || die "Error: $File - $!\n";
		
	while (<FILE>) {
		chop;

		if (/^By service time category:/) {
			print STDERR "BEGIN  TABLE1\n" if $Verbose;
			$TableNum = 1;
			$Num = 0;
		} elsif (/^By percentage finished:/) {
			print STDERR "BEGIN  TABLE2\n" if $Verbose;
			$TableNum = 2;
			$Num = 0;
		} elsif (/=== STATUS CODE REPORT/) {
			print STDERR "BEGIN  TABLE3\n" if $Verbose;
			$TableNum = 3;
			$Num = 0;
		} elsif (/=== DATA FLOW REPORT/) {
			print STDERR "BEGIN  TABLE4\n" if $Verbose;
			$TableNum = 4;
			$Num = 0;
		} elsif (/=== REQUESTS AND CONNECTIONS/) {
			print STDERR "BEGIN  TABLE5\n" if $Verbose;
			$TableNum = 5;
		} elsif (/=== CACHE PERFORMANCE REPORT/) {
			print STDERR "BEGIN  TABLE6\n" if $Verbose;
			$TableNum = 6;
			$Num = 0;
		} elsif (/=== TRANSFER TIME REPORT/) {
			print STDERR "BEGIN  TABLE7\n" if $Verbose;
			$TableNum = 7;
			$Num = 0;
		}

		if ($TableNum == 1) {
			if (/^[<\ ]+(\d*) sec \[(.*)\]/) {
				$XferTimeByService[$Num++] = $2;
				print STDERR "[$1] [$2]\n" if $Verbose;
			}
		} elsif ($TableNum == 2) {
			if (/^[<\ ]+(\d*) sec \[(.*)\]/) {
				$XferTimeByPercent[$Num++] = $2;
				print STDERR "[$1] [$2]\n" if $Verbose;
			}
		} elsif ($TableNum == 3) {
			if (/^\s+([0-9\-]*)\s+(\d*)\s+\[(.*)\]\s+(\d*)\s+\[(.*)\]\s+(.*)/) {
				$StatusCodes[$Num++] = "$1|$6|$2|$3|$4|$5";
				print STDERR "[$StatusCodes[$Num-1]]\n" if $Verbose;
			}
		} elsif ($TableNum == 4) {
			if (/^\s+-\s+([A-z\ \->]*)\.*\s+(\d*) MB\s+(\d*) MB \s+(\d*)/) {
				$DataFlow[$Num++] = "$1|$2|$3|$4";
				print STDERR "[$DataFlow[$Num-1]]\n" if $Verbose;
			}
		} elsif ($TableNum == 5) {
			if (/^\s+-\s+([A-z\ ]*)\.*\s+(\-\d*|\d*)/) {
				$TotalRequests = $2 if (! $TotalRequests);
				$ReqsAndConnections[$Num++] = "$1|$2";
				print STDERR "[$ReqsAndConnections[$Num-1]]\n" if $Verbose;
			}
		} elsif ($TableNum == 6) {
			if (/^\s+-\s+([A-z\&\/?\(\)\ \->]*)\.*\s+(\d*)\s+reqs\s+\[(.*)\]\s+([0-9\.]*)\s+sec\/req\s+(~\d*|\d*)\s+MB/ ||
				/^\s+-\s+([A-z\&\/?\(\)\ \->]*)\.*\s+(\d*)\s+reqs\s+\[(.*)\]\s+([0-9\.]*)\s+sec\/req/ ||
				/^\s+-\s+([A-z\&\/?\(\)\ \->]*)\.*/) {
				$CachePerformance[$Num++] = "$1|$2|$3|$4|$5";
				print STDERR "[$CachePerformance[$Num-1]]\n" if $Verbose;
			}
		} elsif ($TableNum == 7) {
			if (/^\s+-\s+([A-z\/,\ ]*)[\.\s+]*([0-9\.]*)\s+sec/) {
				$XferTime[$Num++] = "$1|$2";
				print STDERR "[$XferTime[$Num-1]]\n" if $Verbose;
			}
		}
	}
	close (FILE);
}

sub ParseLogFile
{
	my ($File) = @_;
	my ($Date) = "";
	my ($Time) = "";
	my ($Type) = "";
	my ($URL) = "";
	my (%MonthNum) = (
		'Jan', 1, 'Feb', 2, 'Mar', 3, 'Apr', 4,  'May', 5,  'Jun', 6,
		'Jul', 7, 'Aug', 8, 'Sep', 9, 'Oct', 10, 'Nov', 11, 'Dec', 12);
		                                                                                                                                                                           	
	print STDERR "Parsing $File ...\n";

	open (FILE, $File) || die "Error: $File - $!\n";

	while (<FILE>) 
	{
		chop;

		# Parse the line and extract the data. Format of one line:
		# 	195.41.10.200 - - [02/Dec/1995:08:03:56 +0100] "GET http://bvp.wdp.com/media/
		#	BVMoviePlex/DeadPresidents/Movies/DP310030N.gif HTTP/1.0" 200 4051
		#
#		if (/(.*) - - \[(..)\/(...)\/(....):(..:..:..)\s+(.*)\]\s+"GET\s+(.*)\s+HTTP.*" (.*)/) {
		if (/(.*) - - \[(..)\/(...)\/(....):(..:..:..)\s+(.*)\]\s+"(GET|CONNECT)\s+(.*)\s+HTTP.*" (.*)/) {
			$From = $1;
			$Day = $2;
			$Month = $3;
			$Year = $4;
			$Time = $5;
			$Type = $7;
			$URL = $8;
			@rest = split(/ /,$9);
#			$URL = $7;
#			@rest = split(/ /,$8);

			#
			# Now we check the LOG Format (Common or Extended)
			#
			if ($Size eq "-") {
				$Size = 0;
			} else {
				$Size = $rest[1];
			}
				
			#
			# Time YYMMDDHHMMSS
			#
			$Time =~ s/://g;
			$Date = sprintf ("%04d%02d%02d", $Year, $MonthNum{$Month}, $Day);
			
			#
			# 1st line: extended log  2nd line: common log
			#
			if (($rest[2] eq "200" || $rest[2] eq "304") || (($rest[0] eq "200") && ( $#rest == 1))) {
				if ($Type =~ /CONNECT/) {
					$TopUrlsCONNECT{$URL} = $TopUrlsCONNECT{$URL} + 1;
				} elsif ($URL =~ /^http:/) {
					$TopUrlsHTTP{$URL} = $TopUrlsHTTP{$URL} + 1;
				} elsif ($URL =~ /^ftp:/) {
					   $TopUrlsFTP{$URL} = $TopUrlsFTP{$URL} + 1;
				}

				if ($Date =~ /^$GenDate/) {				
					&ParseReqsPerHalfHour ($Time);
					$BegTime = $Time if !$BegTime;
				}
			}
#			print STDERR "$Date|$Time| $Size| $From| $URL\n" if $Verbose;
		}		
	}
	close (FILE);

	$EndTime = $Time if $Time;

	print STDERR "TOP URLS - FTP\n" if $Verbose;
	$TmpFile = "$TmpDir/FTP.$$";
	open (FILE, ">$TmpFile") || die "Error: $TmpFile - $!\n";
	foreach $URL (sort keys %TopUrlsFTP) {
		printf FILE "%8d %s\n", $TopUrlsFTP{$URL}, $URL;
	}
	close (FILE);
	`sort -r $TmpFile > $TmpDir/proxy-summary-FTP`;

	print STDERR "TOP URLS - HTTP\n" if $Verbose;
	$TmpFile = "$TmpDir/HTTP.$$";
	open (FILE, ">$TmpFile") || die "Error: $TmpFile - $!\n";
	foreach $URL (sort keys %TopUrlsHTTP) {
		printf FILE "%8d %s\n", $TopUrlsHTTP{$URL}, $URL;
	}
	close (FILE);
	`sort -r $TmpFile > $TmpDir/proxy-summary-HTTP`;

	print STDERR "TOP URLS - CONNECT\n" if $Verbose;
	$TmpFile = "$TmpDir/CONNECT.$$";
	open (FILE, ">$TmpFile") || die "Error: $TmpFile - $!\n";
	foreach $URL (sort keys %TopUrlsCONNECT) {
		printf FILE "%8d %s\n", $TopUrlsCONNECT{$URL}, $URL;
	}
	close (FILE);
	`sort -r $TmpFile > $TmpDir/proxy-summary-CONNECT`;
}

sub GenerateHtmlFile
{
	print <<EOT
<html>
<head>
<title>Netscape Proxy Statistics for $HostName:$PortNum</title>
</head>
<body>
<a name="00">
<h2>Netscape Proxy Statistics for $HostName:$PortNum</h2>
<hr>
<p>
<ol>
<li><a href="#01">Summary of Transfer Times</a>
<li><a href="#02">Summary of Cache Performance</a>
<li><a href="#03">Summary of Data Flow</a>
<li><a href="#04">Summary of Status Codes</a>
<li><a href="#05">Summary of Transfer Time by Service Time</a>
<li><a href="#06">Top $TopN HTTP Requests</a>
<li><a href="#07">Top $TopN FTP Requests</a>
<li><a href="#08">Top $TopN CONNECT Requests</a>
</ol>
<hr>
<p>
EOT
;
	&PrintChart (undef, "Request Distribution, combined HTTP and FTP, per half hour", undef);

	print "<p>\n<a name=\"01\">\n<hr>\n<p>\n";
	&PrintXferTime ("1. Summary of Transfer Times");

	&PrintSeparator ("02");
	&PrintCachePerformance ("2. Summary of Cache Performance");

	&PrintSeparator ("03");
	&PrintDataFlow ("3. Summary of Data Flow");

	&PrintSeparator ("04");
	&PrintStatusCodes ("4. Summary of Status Codes");

	&PrintSeparator ("05");
	&PrintXferTimeByService ("5. Summary of Transfer Time by Service Time Category");

	&PrintSeparator ("06");
	&PrintTopUrls ("6. Top $TopN HTTP Requests", "http");

	&PrintSeparator ("07");
	&PrintTopUrls ("7. Top $TopN FTP Requests", "ftp");

	&PrintSeparator ("08");
	&PrintTopUrls ("8. Top $TopN CONNECT Requests", "connect");

	&PrintSeparator ("end");

	print <<EOT
Generated on $GenDate by 
<a href="$Url">$ScriptName $Version</a>. 
Copyright &copy; 1996 
<a href="mailto:iain\@sbs.de">Iain Lea</a>. 
</body>
</html>	
EOT
;
}
	
sub PrintChart 
{
	my ($hashref,$title,$AK) = @_;
	my ($Max) = 1;
	my ($Num) = 0;
	my (%TOD);
	my ($Date);
	my ($Width) = 8; # 10
	my (@ReqsPercent);
	my (%MonthName) = (
		'01','Jan','02','Feb','03','Mar','04','Apr','05','May','06','Jun',
		'07','Jul','08','Aug','09','Sep','10','Oct','11','Nov','12','Dec');

	$BegTime =~ /(..)(..)(..)/;
	$BegTime = "$1:$2:$3";
	$EndTime =~ /(..)(..)(..)/;
	$EndTime = "$1:$2:$3";
	$GenDate =~ /(....)(..)(..)/;
	$BegTime = $MonthName{$2}." ".int($3)." ".$BegTime." ".$1;
	$EndTime = $MonthName{$2}." ".int($3)." ".$EndTime." ".$1;

	print <<EOT
<table border=2 width=100%>
<caption><h2>Statistics from [$BegTime] to [$EndTime]</h2></caption>
<th>$title<th><th>Requests
<tr>
<td rowspan=12>
EOT
;
	foreach $i (0..47) {
		$Num = $ReqsPerHalfHour[$i];
       	$Max = $Num if ($Num > $Max);
	}
	$ReqPerPix = $Max / $MaxHeight;
#	print STDERR "IL: Max=[$Max] Height=[$MaxHeight] Req/Pix=[$ReqPerPix]\n";
	
	foreach $i (0..47) {
		$Reqs = $ReqsPerHalfHour[$i];
		$Height = int ($Reqs / $ReqPerPix);
		$Height = 1 if $Height < 1;

#		printf STDERR "Reqs=[%5d] Pix=[%5d]\n",  $Reqs, $Height;

		$Percent = ($Reqs / $Max) * 100;
		$Image = "$ImgDir/000-000.gif" if ($Percent == 0);
		$Image = "$ImgDir/000-010.gif" if ($Percent > 0);
		$Image = "$ImgDir/010-020.gif" if ($Percent > 10);
		$Image = "$ImgDir/020-030.gif" if ($Percent > 20);
		$Image = "$ImgDir/030-040.gif" if ($Percent > 30);
		$Image = "$ImgDir/040-050.gif" if ($Percent > 40);
		$Image = "$ImgDir/050-060.gif" if ($Percent > 50);
		$Image = "$ImgDir/060-070.gif" if ($Percent > 60);
		$Image = "$ImgDir/070-080.gif" if ($Percent > 70);
		$Image = "$ImgDir/080-090.gif" if ($Percent > 80);
		$Image = "$ImgDir/090-100.gif" if ($Percent > 90);

		print "<img src=\"$Image\" border=0 width=$Width height=$Height>";
	}

	foreach $i (0 .. 9) {
		$ReqsPercent[$i] = int(($Max / 10) * ($i+1));
	}
	
	$BarWidth = $Width * 48;
	
	print <<EOT
<br>
<img src="$ImgDir/ampm-bar.gif" width=$BarWidth height=22 border=0 hspace=0 vspace=0>
</td>
<tr>
<td><strong>Total<strong>
<td align="right">$TotalRequests
<tr>
<td><img src="$ImgDir/090-100.gif" width=10 height=10> &gt 90%
<td align="right">$ReqsPercent[9]
<tr>
<td><img src="$ImgDir/080-090.gif" width=10 height=10> &gt 80%
<td align="right">$ReqsPercent[8]
<tr>
<td><img src="$ImgDir/070-080.gif" width=10 height=10> &gt 70%
<td align="right">$ReqsPercent[7]
<tr>
<td><img src="$ImgDir/060-070.gif" width=10 height=10> &gt 60%
<td align="right">$ReqsPercent[6]
<tr>
<td><img src="$ImgDir/050-060.gif" width=10 height=10> &gt 50%
<td align="right">$ReqsPercent[5]
<tr>
<td><img src="$ImgDir/040-050.gif" width=10 height=10> &gt 40%
<td align="right">$ReqsPercent[4]
<tr>
<td><img src="$ImgDir/030-040.gif" width=10 height=10> &gt 30%
<td align="right">$ReqsPercent[3]
<tr>
<td><img src="$ImgDir/020-030.gif" width=10 height=10> &gt 20%
<td align="right">$ReqsPercent[2]
<tr>
<td><img src="$ImgDir/010-020.gif" width=10 height=10> &gt 10%
<td align="right">$ReqsPercent[1]
<tr>
<td><img src="$ImgDir/000-010.gif" width=10 height=10> &gt 0%
<td align="right">$ReqsPercent[0]
</table>
EOT
;
}

sub PrintSeparator
{
	my ($Num) = @_;

	if ($Num =~ /beg/i) {
		print "<p>\n<hr>\n<p>\n";
	} elsif ($Num =~ /end/i) {
		print "<a href=\"#00\">Goto Top</a>\n";
		print "<p>\n<hr>\n";
	} else {
		print "<a name=\"$Num\">\n";
		print "<a href=\"#00\">Goto Top</a>\n";
		print "<p>\n<hr>\n<p>\n";
	}
}

sub PrintXferTimeByService
{
	my ($Title) = @_;

	&PrintTableHeader ($Title);

	print "<th>Time<th>Percent\n";
	
	foreach $Num (0..@XferTimeByService) {
		$Secs = $Num+1;
		if ($XferTimeByService[$Num] ne '') {
			print "<tr>\n<td align=\"right\">&lt; $Secs secs\n";
			print "<td align=\"right\">$XferTimeByService[$Num]\n";
		}
	}
	
	&PrintTableFooter;
}

sub PrintXferTimeByPercent
{
	my ($Title) = @_;

	&PrintTableHeader ($Title);

	print "<th>Time<th>Finished\n";
	
	foreach $Num (0..@XferTimeByPercent) {
		$Secs = $Num+1;
		if ($XferTimeByPercent[$Num] ne '') {
			print "<tr>\n<td align=\"right\">&lt; $Secs secs\n";
			print "<td align=\"right\">$XferTimeByPercent[$Num]\n";
		}
	}
	
	&PrintTableFooter;
}

sub PrintStatusCodes
{
	my ($Title) = @_;

	&PrintTableHeader ($Title);

	print "<th>Code<th colspan=2>From Remote<th colspan=2>To Client\n";
	
	foreach $Num (0..@StatusCodes) {
		@Line = split ('\|', $StatusCodes[$Num]);
		if ($Line[0] ne '') {
			print "<tr>\n<td><strong>$Line[0]</strong> $Line[1]\n";
			print "<td align=\"right\">$Line[2]\n";
			print "<td align=\"right\">$Line[3]\n";
			print "<td align=\"right\">$Line[4]\n";
			print "<td align=\"right\">$Line[5]\n";
		}	
	}

	&PrintTableFooter;
}

sub PrintDataFlow
{
	my ($Title) = @_;

	&PrintTableHeader ($Title);

	print "<th>Direction<th>Headers<th>Content<th>Total\n";
	
	foreach $Num (0..@DataFlow) {
		@Line = split ('\|', $DataFlow[$Num]);
		if ($Line[0] ne '') {
			print "<tr>\n<td>$Line[0]\n";
			print "<td align=\"right\">$Line[1] MB\n";
			print "<td align=\"right\">$Line[2] MB\n";
			print "<td align=\"right\">$Line[3] MB\n";
		}
	}

	&PrintTableFooter;
}

sub PrintReqsAndConnections
{
	my ($Title) = @_;

	&PrintTableHeader ($Title);

	print "<th>Action<th>Total\n";

	foreach $Num (0..@ReqsAndConnections) {
		@Line = split ('\|', $ReqsAndConnections[$Num]);
		if ($Line[0] ne '') {
			print "<tr>\n<td>$Line[0]<td align=\"right\">$Line[1]\n";
		}
	}

	&PrintTableFooter;
}

sub PrintCachePerformance
{
	my ($Title) = @_;

	&PrintTableHeader ($Title);

	print "<th>Action<th>Requests<th>Hits%<th>Seconds/Req<th>Volume\n";

	foreach $Num (0..@CachePerformance) {
		@Line = split ('\|', $CachePerformance[$Num]);
		if ($Line[0] ne '') {
			$MB = ($Line[4] ne "" ? " MB" : "");
			print "<tr>\n<td>$Line[0]\n";
			print "<td align=\"right\">$Line[1]\n";
			print "<td align=\"right\">$Line[2]\n";
			print "<td align=\"right\">$Line[3]\n";
			print "<td align=\"right\">$Line[4]$MB\n";
		}
	}

	&PrintTableFooter;
}

sub PrintXferTime
{
	my ($Title) = @_;
	
	&PrintTableHeader ($Title);

	print "<th>Action<th>Seconds/Req\n";

	foreach $Num (0..@XferTime) {
		@Line = split ('\|', $XferTime[$Num]);
		if ($Line[0] ne '') {
			print "<tr>\n<td>$Line[0]\n";
			print "<td align=\"right\">$Line[1]\n";
		}
	}

	&PrintTableFooter;
}

sub PrintTopUrls
{
	my ($Title, $Type) = @_;
	my ($Num) = 0;
	my ($File);
	my ($IsTypeFTP, $IsTypeHTTP, $IsTypeCONNECT);

	$IsTypeFTP = $IsTypeHTTP = $IsTypeCONNECT = 0;
	
	&PrintTableHeader ($Title);

	print "<th>Hits<th>URL\n";

	if ($Type =~ /ftp/) {
		$File = "$TmpDir/proxy-summary-FTP";
		$IsTypeFTP++;
	} elsif ($Type =~ /http/) {
		$File = "$TmpDir/proxy-summary-HTTP";
		$IsTypeHTTP++;
	} else {
		$File = "$TmpDir/proxy-summary-CONNECT";
		$IsTypeCONNECT++;
	}
	open (URLS, $File) || die "Error: $File - $!\n";

	while (<URLS>) {
		@Line = split;
		if ($Line[0] ne "" && $Num < $TopN) {
			if ($IsTypeFTP) {
				print "<tr>\n<td align=\"right\">$Line[0]<td><a href=\"$Line[1]\">$Line[1]</a>\n";
				$Num++;
			} elsif ($IsTypeHTTP || $IsTypeCONNECT) {
				if ($NoCruft) {
					if ($Line[1] =~ /\.gif$/ || $Line[1] =~ /\.jpg$/ ||
						$Line[1] =~ /\/cgi-bin\//) {
						print STDERR "CRUFT: $Line[1]\n" if $Verbose;
					} else {
						print "<tr>\n<td align=\"right\">$Line[0]<td><a href=\"$Line[1]\">$Line[1]</a>\n";
						$Num++;
					}
				} else {
					print "<tr>\n<td align=\"right\">$Line[0]<td><a href=\"$Line[1]\">$Line[1]</a>\n";
					$Num++;
				}
			}
		}
	}

	close (URLS);
	unlink ($File);

	&PrintTableFooter;
}


sub PrintTableHeader
{
	my ($Title) = @_;

	print <<EOT
<table border=2 width=100%>
<caption><h2>$Title</h2></caption>
EOT
;
}


sub PrintTableFooter
{
	print "</table>\n";
}

sub ParseReqsPerHalfHour
{
	my ($Time) = @_;
	my ($Idx) = 0;
	my ($Num);

	foreach $Num (0..47) {
		if ($Time >= $HalfHour[$Idx++] && $Time <= $HalfHour[$Idx++]) {
			$ReqsPerHalfHour[$Num] = $ReqsPerHalfHour[$Num] + 1;
#			print STDERR "[$Time]  $HalfHour[$Idx-2] - $HalfHour[$Idx-1]  $ReqsPerHalfHour[$Num]\n";
			return;
		}
	}
}

sub InitReqsPerHalfHour
{
	@HalfHour = (
		'000000', '002959',
		'003000', '005959',
		'010000', '012959',
		'013000', '015959',
		'020000', '022959',
		'023000', '025959',
		'030000', '032959',
		'033000', '035959',
		'040000', '042959',
		'043000', '045959',
		'050000', '052959',
		'053000', '055959',
		'060000', '062959',
		'063000', '065959',
		'070000', '072959',
		'073000', '075959',
		'080000', '082959',
		'083000', '085959',
		'090000', '092959',
		'093000', '095959',
		'100000', '102959',
		'103000', '105959',
		'110000', '112959',
		'113000', '115959',
		'120000', '122959',
		'123000', '125959',
		'130000', '132959',
		'133000', '135959',
		'140000', '142959',
		'143000', '145959',
		'150000', '152959',
		'153000', '155959',
		'160000', '162959',
		'163000', '165959',
		'170000', '172959',
		'173000', '175959',
		'180000', '182959',
		'183000', '185959',
		'190000', '192959',
		'193000', '195959',
		'200000', '202959',
		'203000', '205959',
		'210000', '212959',
		'213000', '215959',
		'220000', '222959',
		'223000', '225959',
		'230000', '232959',
		'233000', '235959');
}
