/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.execute.ExecAggregator;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLLongint;
import org.apache.derby.impl.sql.execute.SystemAggregator;

public final class CountAggregator
extends SystemAggregator {
    private long value;
    private boolean isCountStar;

    public void setup(String string) {
        this.isCountStar = string.equals("COUNT(*)");
    }

    public void merge(ExecAggregator execAggregator) throws StandardException {
        this.value += ((CountAggregator)execAggregator).value;
    }

    public DataValueDescriptor getResult() {
        return new SQLLongint(this.value);
    }

    public void accumulate(DataValueDescriptor dataValueDescriptor, Object object) throws StandardException {
        if (this.isCountStar) {
            ++this.value;
        } else {
            super.accumulate(dataValueDescriptor, object);
        }
    }

    protected final void accumulate(DataValueDescriptor dataValueDescriptor) {
        ++this.value;
    }

    public ExecAggregator newAggregator() {
        CountAggregator countAggregator = new CountAggregator();
        countAggregator.isCountStar = this.isCountStar;
        return countAggregator;
    }

    public boolean isCountStar() {
        return this.isCountStar;
    }

    public final void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeBoolean(this.isCountStar);
        objectOutput.writeLong(this.value);
    }

    public final void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.isCountStar = objectInput.readBoolean();
        this.value = objectInput.readLong();
    }

    public int getTypeFormatId() {
        return 151;
    }
}

