use strict;
use warnings;
use ExtUtils::MakeMaker;

WriteMakefile(
    NAME                => 'Crypt::SMIME',
    AUTHOR              => 'Ymirlink <tl@tripletail.jp>',
    VERSION_FROM        => 'SMIME.pl',
    ABSTRACT            => 'S/MIME message signing, verification, encryption and decryption',
    PL_FILES            => {},
    CONFIGURE_REQUIRES  => {
        'ExtUtils::MakeMaker' => 0,
        'ExtUtils::PkgConfig' => 0,
    },
    PREREQ_PM           => {
        'XSLoader'      => 0,
    },
    BUILD_REQUIRES      => {
        'ExtUtils::PkgConfig' => 0,
        'Test::Exception'     => 0,
        'Test::More'          => 0,
    },
    CONFIGURE           => sub {
        require ExtUtils::PkgConfig;

        local $| = 1;

        print 'checking for LIBCRYPTO_CFLAGS... ';
        my $LIBCRYPTO_CFLAGS = ExtUtils::PkgConfig->cflags('libcrypto');
        print "$LIBCRYPTO_CFLAGS\n";

        print 'checking for LIBCRYPTO_LIBS... ';
        my $LIBCRYPTO_LIBS = ExtUtils::PkgConfig->libs('libcrypto');
        print "$LIBCRYPTO_LIBS\n";

        return +{
            INC  => "$LIBCRYPTO_CFLAGS -DOPENSSL_LOAD_CONF",
            LIBS => $LIBCRYPTO_LIBS,
        };
    },
    dist                => { COMPRESS => 'gzip -9f', SUFFIX => 'gz', },
    clean               => {
        FILES => 'Crypt-SMIME-*',
    },
    PM                  => {
        'lib/SMIME.pm'     => '$(INST_LIBDIR)/SMIME.pm',
        'lib/SMIME/JA.pod' => '$(INST_LIBDIR)/SMIME/JA.pod',
    },
    depend              => {
        'lib/SMIME.pm'
          => "SMIME.pl SMIME.pod\n" .
             "\tmkdir -p lib\n" .
             "\techo \"# This file is automatically generated from SMIME.pl\"           > \$\@\n" .
             "\techo \"# All of your changes will be lost if you edit this directly.\" >> \$\@\n" .
             "\tcat SMIME.pl  >> \$\@\n" .
             "\techo          >> \$\@\n" .
             "\techo __END__  >> \$\@\n" .
             "\techo          >> \$\@\n" .
             "\tcat SMIME.pod >> \$\@\n",

        'SMIME.pod'
          => "SMIME.mlpod\n" .
             "\tmlpod2pod \$< > \$\@",

        'lib/SMIME/JA.pod'
          => "SMIME.mlpod\n" .
             "\tmkdir -p lib/SMIME\n" .
             "\tmlpod2pod --langs=ja \$< | perl -pe 's/(\\xe5\\x90\\x8d\\xe5\\x89\\x8d)/NAME/' > \$\@",
    },
);
