use strict;
use Test::More tests => 2;

use Crypt::OpenPGP;

use vars qw( $SAMPLES );
unshift @INC, 't/';
require 'test-common.pl';
use File::Spec;


my $key_id = '43AA1C85';
my $pass = "";
my $uid = 'Test Key (SHA-512 key for Crypt::OpenPGP tests) <test@sha512.sig>';

my $secring = File::Spec->catfile( $SAMPLES, 'gpg', 'sha2.sec' );
my $pubring = File::Spec->catfile( $SAMPLES, 'gpg', 'sha2.pub' );
my $pgp = Crypt::OpenPGP->new(
    SecRing => $secring,
    PubRing => $pubring,
);
isa_ok $pgp, 'Crypt::OpenPGP';

{
    diag 'sig generated by gpg with SHA512';

    # Test a signature created by gnupg with SHA512 key
    my $sig_file = File::Spec->catfile( $SAMPLES, 'sha2.asc' );
    my $signer = $pgp->verify( SigFile => $sig_file );
    is $signer, $uid, 'verified as signed by uid';
}
