#!/usr/bin/env perl

use strict;
use warnings;

use Test::More tests => 717;

BEGIN {use_ok('Finance::AMEX::Transaction')}

use lib '.';
use t::lib::CompareFile;

my $file = 't/data/AMEX/EPRAW sample test file.txt';

my $counts = {
  HEADER            => {want => 5,  have => 0},
  TRAILER           => {want => 5,  have => 0},
  SUMMARY           => {want => 5,  have => 0},
  SOC_DETAIL        => {want => 13, have => 0},
  CHARGEBACK_DETAIL => {want => 5,  have => 0},
  ADJUSTMENT_DETAIL => {want => 1,  have => 0},
  OTHER_DETAIL      => {want => 2,  have => 0},
};

my $data = do {local $/ = undef; <DATA>};

t::lib::CompareFile::compare('EPRAW', $file, $data, $counts);

done_testing();

__DATA__
{
  "HEADER": [
    { "DF_HDR_DATE": "07062013", "DF_HDR_FILE_ID": "000000", "DF_HDR_FILE_NAME": "AMEX TESTING SAMPLE", "DF_HDR_RECORD_TYPE": "DFHDR", "DF_HDR_TIME": "0518" },
    { "DF_HDR_DATE": "07062013", "DF_HDR_FILE_ID": "000000", "DF_HDR_FILE_NAME": "AMEX TESTING SAMPLE", "DF_HDR_RECORD_TYPE": "DFHDR", "DF_HDR_TIME": "0518" },
    { "DF_HDR_DATE": "07062013", "DF_HDR_FILE_ID": "000000", "DF_HDR_FILE_NAME": "AMEX TESTING SAMPLE", "DF_HDR_RECORD_TYPE": "DFHDR", "DF_HDR_TIME": "0518" },
    { "DF_HDR_DATE": "07062013", "DF_HDR_FILE_ID": "000000", "DF_HDR_FILE_NAME": "AMEX TESTING SAMPLE", "DF_HDR_RECORD_TYPE": "DFHDR", "DF_HDR_TIME": "0518" },
    { "DF_HDR_DATE": "07062013", "DF_HDR_FILE_ID": "000000", "DF_HDR_FILE_NAME": "AMEX TESTING SAMPLE", "DF_HDR_RECORD_TYPE": "DFHDR", "DF_HDR_TIME": "0518" }
  ],
  "TRAILER": [
    { "DF_TRL_DATE": "07062013", "DF_TRL_FILE_ID": "000000", "DF_TRL_FILE_NAME": "AMEX TESTING SAMPLE", "DF_TRL_RECIPIENT_KEY": "00000000006316711035          0000000000", "DF_TRL_RECORD_COUNT": "0000059", "DF_TRL_RECORD_TYPE": "DFTRL", "DF_TRL_TIME": "0518" },
    { "DF_TRL_DATE": "07062013", "DF_TRL_FILE_ID": "000000", "DF_TRL_FILE_NAME": "AMEX TESTING SAMPLE", "DF_TRL_RECIPIENT_KEY": "00000000006316725407          0000000000", "DF_TRL_RECORD_COUNT": "0013645", "DF_TRL_RECORD_TYPE": "DFTRL", "DF_TRL_TIME": "0518" },
    { "DF_TRL_DATE": "07062013", "DF_TRL_FILE_ID": "000000", "DF_TRL_FILE_NAME": "AMEX TESTING SAMPLE", "DF_TRL_RECIPIENT_KEY": "00000000006316726140          0000000000", "DF_TRL_RECORD_COUNT": "0000108", "DF_TRL_RECORD_TYPE": "DFTRL", "DF_TRL_TIME": "0518" },
    { "DF_TRL_DATE": "07062013", "DF_TRL_FILE_ID": "000000", "DF_TRL_FILE_NAME": "AMEX TESTING SAMPLE", "DF_TRL_RECIPIENT_KEY": "00000000006316754639          0000000000", "DF_TRL_RECORD_COUNT": "0000008", "DF_TRL_RECORD_TYPE": "DFTRL", "DF_TRL_TIME": "0518" },
    { "DF_TRL_DATE": "07062013", "DF_TRL_FILE_ID": "000000", "DF_TRL_FILE_NAME": "AMEX TESTING SAMPLE", "DF_TRL_RECIPIENT_KEY": "00000000006316764380          0000000000", "DF_TRL_RECORD_COUNT": "0000100", "DF_TRL_RECORD_TYPE": "DFTRL", "DF_TRL_TIME": "0518" }
  ],
  "SUMMARY": [
    { "ABA_BANK_NUMBER": "021999921", "AMEX_PAYEE_NUMBER": "1116711035", "AMEX_SORT_FIELD_1": "0000000000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000019814H", "PAYMENT_DATE": "2013189", "PAYMENT_NUMBER": "186S0224", "PAYMENT_NUMBER_DATE": "186", "PAYMENT_NUMBER_NUMBER": "0224", "PAYMENT_NUMBER_TYPE": "S", "PAYMENT_YEAR": "2013", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "099999302" },
    { "ABA_BANK_NUMBER": "021999921", "AMEX_PAYEE_NUMBER": "1116725407", "AMEX_SORT_FIELD_1": "0000000000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0005518585B", "PAYMENT_DATE": "2013189", "PAYMENT_NUMBER": "186V6412", "PAYMENT_NUMBER_DATE": "186", "PAYMENT_NUMBER_NUMBER": "6412", "PAYMENT_NUMBER_TYPE": "V", "PAYMENT_YEAR": "2013", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "099999302" },
    { "ABA_BANK_NUMBER": "021999921", "AMEX_PAYEE_NUMBER": "1116726140", "AMEX_SORT_FIELD_1": "0000000000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000037087J", "PAYMENT_DATE": "2013189", "PAYMENT_NUMBER": "186V6414", "PAYMENT_NUMBER_DATE": "186", "PAYMENT_NUMBER_NUMBER": "6414", "PAYMENT_NUMBER_TYPE": "V", "PAYMENT_YEAR": "2013", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "099999302" },
    { "ABA_BANK_NUMBER": "021999921", "AMEX_PAYEE_NUMBER": "1116754639", "AMEX_SORT_FIELD_1": "0000000000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000000650N", "PAYMENT_DATE": "2013189", "PAYMENT_NUMBER": "186V6415", "PAYMENT_NUMBER_DATE": "186", "PAYMENT_NUMBER_NUMBER": "6415", "PAYMENT_NUMBER_TYPE": "V", "PAYMENT_YEAR": "2013", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "099999302" },
    { "ABA_BANK_NUMBER": "021999921", "AMEX_PAYEE_NUMBER": "1116764380", "AMEX_SORT_FIELD_1": "0000000000", "AMEX_SORT_FIELD_2": "0000000000", "DEBIT_BALANCE_AMOUNT": "00000000{", "DETAIL_RECORD_TYPE": "00", "PAYMENT_AMOUNT": "0000034949H", "PAYMENT_DATE": "2013189", "PAYMENT_NUMBER": "186S0225", "PAYMENT_NUMBER_DATE": "186", "PAYMENT_NUMBER_NUMBER": "0225", "PAYMENT_NUMBER_TYPE": "S", "PAYMENT_YEAR": "2013", "RECORD_TYPE": 1, "SE_DDA_NUMBER": "099999302" }
  ],
  "SOC_DETAIL": [
    { "AMEX_GROSS_AMOUNT": "0000020396A", "AMEX_PAYEE_NUMBER": "1116711035", "AMEX_PROCESS_DATE": "2013186", "AMEX_ROC_COUNT": "0005E", "AMEX_ROC_COUNT_POA": "000005E", "AMEX_SE_NUMBER": "1116711035", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": "10", "DISCOUNT_AMOUNT": "00000581C", "DISCOUNT_RATE": "02850", "NET_SOC_AMOUNT": "0000019814H", "OPTIMA_DIVIDEND_AMOUNT": "000000{", "OPTIMA_DIVIDEND_RATE": "00000", "OPTIMA_GROSS_AMOUNT": "0000000000{", "OPTIMA_ROC_COUNT": "0000{", "PAYMENT_NUMBER": "186S0224", "PAYMENT_NUMBER_DATE": "186", "PAYMENT_NUMBER_NUMBER": "0224", "PAYMENT_NUMBER_TYPE": "S", "PAYMENT_YEAR": "2013", "RECORD_TYPE": "2", "SE_BUSINESS_DATE": "2013186", "SERVICE_AGENT_MERCHANT_ID": "", "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": "STORE 5", "SOC_AMOUNT": "0000020396A", "SOC_INVOICE_NUMBER": "000765", "TRACKING_ID": "186098799", "TRACKING_ID_DATE": "186", "TRACKING_ID_PCID": "098799" },
    { "AMEX_GROSS_AMOUNT": "0000000360{", "AMEX_PAYEE_NUMBER": "1116725407", "AMEX_PROCESS_DATE": "2013185", "AMEX_ROC_COUNT": "0000C", "AMEX_ROC_COUNT_POA": "000000C", "AMEX_SE_NUMBER": "1116725407", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": "10", "DISCOUNT_AMOUNT": "00000010C", "DISCOUNT_RATE": "02850", "NET_SOC_AMOUNT": "0000000349G", "OPTIMA_DIVIDEND_AMOUNT": "000000{", "OPTIMA_DIVIDEND_RATE": "00000", "OPTIMA_GROSS_AMOUNT": "0000000000{", "OPTIMA_ROC_COUNT": "0000{", "PAYMENT_NUMBER": "186V6412", "PAYMENT_NUMBER_DATE": "186", "PAYMENT_NUMBER_NUMBER": "6412", "PAYMENT_NUMBER_TYPE": "V", "PAYMENT_YEAR": "2013", "RECORD_TYPE": "2", "SE_BUSINESS_DATE": "2013185", "SERVICE_AGENT_MERCHANT_ID": "", "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": "STORE 6", "SOC_AMOUNT": "0000000360{", "SOC_INVOICE_NUMBER": "000548", "TRACKING_ID": "185098799", "TRACKING_ID_DATE": "185", "TRACKING_ID_PCID": "098799" },
    { "AMEX_GROSS_AMOUNT": "0000000180{", "AMEX_PAYEE_NUMBER": "1116725407", "AMEX_PROCESS_DATE": "2013186", "AMEX_ROC_COUNT": "0000A", "AMEX_ROC_COUNT_POA": "000000A", "AMEX_SE_NUMBER": "1116725407", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": "10", "DISCOUNT_AMOUNT": "00000005A", "DISCOUNT_RATE": "02850", "NET_SOC_AMOUNT": "0000000174I", "OPTIMA_DIVIDEND_AMOUNT": "000000{", "OPTIMA_DIVIDEND_RATE": "00000", "OPTIMA_GROSS_AMOUNT": "0000000000{", "OPTIMA_ROC_COUNT": "0000{", "PAYMENT_NUMBER": "186V6412", "PAYMENT_NUMBER_DATE": "186", "PAYMENT_NUMBER_NUMBER": "6412", "PAYMENT_NUMBER_TYPE": "V", "PAYMENT_YEAR": "2013", "RECORD_TYPE": "2", "SE_BUSINESS_DATE": "2013186", "SERVICE_AGENT_MERCHANT_ID": "", "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": "STORE 6", "SOC_AMOUNT": "0000000180{", "SOC_INVOICE_NUMBER": "000652", "TRACKING_ID": "186098799", "TRACKING_ID_DATE": "186", "TRACKING_ID_PCID": "098799" },
    { "AMEX_GROSS_AMOUNT": "0000001040C", "AMEX_PAYEE_NUMBER": "1116725407", "AMEX_PROCESS_DATE": "2013186", "AMEX_ROC_COUNT": "0000D", "AMEX_ROC_COUNT_POA": "000000D", "AMEX_SE_NUMBER": "1116725407", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": "10", "DISCOUNT_AMOUNT": "00000029F", "DISCOUNT_RATE": "02850", "NET_SOC_AMOUNT": "0000001010G", "OPTIMA_DIVIDEND_AMOUNT": "000000{", "OPTIMA_DIVIDEND_RATE": "00000", "OPTIMA_GROSS_AMOUNT": "0000000000{", "OPTIMA_ROC_COUNT": "0000{", "PAYMENT_NUMBER": "186V6412", "PAYMENT_NUMBER_DATE": "186", "PAYMENT_NUMBER_NUMBER": "6412", "PAYMENT_NUMBER_TYPE": "V", "PAYMENT_YEAR": "2013", "RECORD_TYPE": "2", "SE_BUSINESS_DATE": "2013186", "SERVICE_AGENT_MERCHANT_ID": "", "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": "STORE 6", "SOC_AMOUNT": "0000001040C", "SOC_INVOICE_NUMBER": "006566", "TRACKING_ID": "186098799", "TRACKING_ID_DATE": "186", "TRACKING_ID_PCID": "098799" },
    { "AMEX_GROSS_AMOUNT": "0000002048Q", "AMEX_PAYEE_NUMBER": "1116725407", "AMEX_PROCESS_DATE": "2013185", "AMEX_ROC_COUNT": "0000E", "AMEX_ROC_COUNT_POA": "000000E", "AMEX_SE_NUMBER": "1116725407", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": "10", "DISCOUNT_AMOUNT": "00000058M", "DISCOUNT_RATE": "02850", "NET_SOC_AMOUNT": "0000002015M", "OPTIMA_DIVIDEND_AMOUNT": "000000{", "OPTIMA_DIVIDEND_RATE": "00000", "OPTIMA_GROSS_AMOUNT": "0000000000{", "OPTIMA_ROC_COUNT": "0000{", "PAYMENT_NUMBER": "186V6412", "PAYMENT_NUMBER_DATE": "186", "PAYMENT_NUMBER_NUMBER": "6412", "PAYMENT_NUMBER_TYPE": "V", "PAYMENT_YEAR": "2013", "RECORD_TYPE": "2", "SE_BUSINESS_DATE": "2013185", "SERVICE_AGENT_MERCHANT_ID": "", "SERVICE_FEE_AMOUNT": "000025{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": "STORE 6", "SOC_AMOUNT": "0000002048Q", "SOC_INVOICE_NUMBER": "185375", "TRACKING_ID": "185001375", "TRACKING_ID_DATE": "185", "TRACKING_ID_PCID": "001375" },
    { "AMEX_GROSS_AMOUNT": "0000000450{", "AMEX_PAYEE_NUMBER": "1116725407", "AMEX_PROCESS_DATE": "2013185", "AMEX_ROC_COUNT": "0000A", "AMEX_ROC_COUNT_POA": "000000A", "AMEX_SE_NUMBER": "1116725407", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": "10", "DISCOUNT_AMOUNT": "00000012H", "DISCOUNT_RATE": "02850", "NET_SOC_AMOUNT": "0000000437B", "OPTIMA_DIVIDEND_AMOUNT": "000000{", "OPTIMA_DIVIDEND_RATE": "00000", "OPTIMA_GROSS_AMOUNT": "0000000000{", "OPTIMA_ROC_COUNT": "0000{", "PAYMENT_NUMBER": "186V6412", "PAYMENT_NUMBER_DATE": "186", "PAYMENT_NUMBER_NUMBER": "6412", "PAYMENT_NUMBER_TYPE": "V", "PAYMENT_YEAR": "2013", "RECORD_TYPE": "2", "SE_BUSINESS_DATE": "2013185", "SERVICE_AGENT_MERCHANT_ID": "", "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": "STORE 6", "SOC_AMOUNT": "0000000450{", "SOC_INVOICE_NUMBER": "185375", "TRACKING_ID": "185001375", "TRACKING_ID_DATE": "185", "TRACKING_ID_PCID": "001375" },
    { "AMEX_GROSS_AMOUNT": "0000020632F", "AMEX_PAYEE_NUMBER": "1116725407", "AMEX_PROCESS_DATE": "2013185", "AMEX_ROC_COUNT": "0009D", "AMEX_ROC_COUNT_POA": "000009D", "AMEX_SE_NUMBER": "1116725407", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": "10", "DISCOUNT_AMOUNT": "00000588{", "DISCOUNT_RATE": "02850", "NET_SOC_AMOUNT": "0000020044F", "OPTIMA_DIVIDEND_AMOUNT": "000000{", "OPTIMA_DIVIDEND_RATE": "00000", "OPTIMA_GROSS_AMOUNT": "0000000000{", "OPTIMA_ROC_COUNT": "0000{", "PAYMENT_NUMBER": "186V6412", "PAYMENT_NUMBER_DATE": "186", "PAYMENT_NUMBER_NUMBER": "6412", "PAYMENT_NUMBER_TYPE": "V", "PAYMENT_YEAR": "2013", "RECORD_TYPE": "2", "SE_BUSINESS_DATE": "2013185", "SERVICE_AGENT_MERCHANT_ID": "", "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": "STORE 6", "SOC_AMOUNT": "0000020632F", "SOC_INVOICE_NUMBER": "185375", "TRACKING_ID": "185001375", "TRACKING_ID_DATE": "185", "TRACKING_ID_PCID": "001375" },
    { "AMEX_GROSS_AMOUNT": "0002189469D", "AMEX_PAYEE_NUMBER": "1116725407", "AMEX_PROCESS_DATE": "2013185", "AMEX_ROC_COUNT": "0508D", "AMEX_ROC_COUNT_POA": "000508D", "AMEX_SE_NUMBER": "1116725407", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": "10", "DISCOUNT_AMOUNT": "00062399I", "DISCOUNT_RATE": "02850", "NET_SOC_AMOUNT": "0002126859E", "OPTIMA_DIVIDEND_AMOUNT": "000000{", "OPTIMA_DIVIDEND_RATE": "00000", "OPTIMA_GROSS_AMOUNT": "0000000000{", "OPTIMA_ROC_COUNT": "0000{", "PAYMENT_NUMBER": "186V6412", "PAYMENT_NUMBER_DATE": "186", "PAYMENT_NUMBER_NUMBER": "6412", "PAYMENT_NUMBER_TYPE": "V", "PAYMENT_YEAR": "2013", "RECORD_TYPE": "2", "SE_BUSINESS_DATE": "2013185", "SERVICE_AGENT_MERCHANT_ID": "", "SERVICE_FEE_AMOUNT": "000210{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": "STORE 6", "SOC_AMOUNT": "0002189469D", "SOC_INVOICE_NUMBER": "185375", "TRACKING_ID": "185001375", "TRACKING_ID_DATE": "185", "TRACKING_ID_PCID": "001375" },
    { "AMEX_GROSS_AMOUNT": "0000000450{", "AMEX_PAYEE_NUMBER": "1116725407", "AMEX_PROCESS_DATE": "2013186", "AMEX_ROC_COUNT": "0000A", "AMEX_ROC_COUNT_POA": "000000A", "AMEX_SE_NUMBER": "1116725407", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": "10", "DISCOUNT_AMOUNT": "00000012H", "DISCOUNT_RATE": "02850", "NET_SOC_AMOUNT": "0000000437B", "OPTIMA_DIVIDEND_AMOUNT": "000000{", "OPTIMA_DIVIDEND_RATE": "00000", "OPTIMA_GROSS_AMOUNT": "0000000000{", "OPTIMA_ROC_COUNT": "0000{", "PAYMENT_NUMBER": "186V6412", "PAYMENT_NUMBER_DATE": "186", "PAYMENT_NUMBER_NUMBER": "6412", "PAYMENT_NUMBER_TYPE": "V", "PAYMENT_YEAR": "2013", "RECORD_TYPE": "2", "SE_BUSINESS_DATE": "2013186", "SERVICE_AGENT_MERCHANT_ID": "", "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": "STORE 6", "SOC_AMOUNT": "0000000450{", "SOC_INVOICE_NUMBER": "186375", "TRACKING_ID": "186001375", "TRACKING_ID_DATE": "186", "TRACKING_ID_PCID": "001375" },
    { "AMEX_GROSS_AMOUNT": "0003599160B", "AMEX_PAYEE_NUMBER": "1116725407", "AMEX_PROCESS_DATE": "2013186", "AMEX_ROC_COUNT": "0879A", "AMEX_ROC_COUNT_POA": "000879A", "AMEX_SE_NUMBER": "1116725407", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": "10", "DISCOUNT_AMOUNT": "00102576A", "DISCOUNT_RATE": "02850", "NET_SOC_AMOUNT": "0003496539A", "OPTIMA_DIVIDEND_AMOUNT": "000000{", "OPTIMA_DIVIDEND_RATE": "00000", "OPTIMA_GROSS_AMOUNT": "0000000000{", "OPTIMA_ROC_COUNT": "0000{", "PAYMENT_NUMBER": "186V6412", "PAYMENT_NUMBER_DATE": "186", "PAYMENT_NUMBER_NUMBER": "6412", "PAYMENT_NUMBER_TYPE": "V", "PAYMENT_YEAR": "2013", "RECORD_TYPE": "2", "SE_BUSINESS_DATE": "2013186", "SERVICE_AGENT_MERCHANT_ID": "", "SERVICE_FEE_AMOUNT": "000045{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": "STORE 6", "SOC_AMOUNT": "0003599160B", "SOC_INVOICE_NUMBER": "186375", "TRACKING_ID": "186001375", "TRACKING_ID_DATE": "186", "TRACKING_ID_PCID": "001375" },
    { "AMEX_GROSS_AMOUNT": "0000038012P", "AMEX_PAYEE_NUMBER": "1116726140", "AMEX_PROCESS_DATE": "2013185", "AMEX_ROC_COUNT": "0010C", "AMEX_ROC_COUNT_POA": "000010C", "AMEX_SE_NUMBER": "1116726140", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": "10", "DISCOUNT_AMOUNT": "00001083M", "DISCOUNT_RATE": "02850", "NET_SOC_AMOUNT": "0000037444L", "OPTIMA_DIVIDEND_AMOUNT": "000000{", "OPTIMA_DIVIDEND_RATE": "00000", "OPTIMA_GROSS_AMOUNT": "0000000000{", "OPTIMA_ROC_COUNT": "0000{", "PAYMENT_NUMBER": "186V6414", "PAYMENT_NUMBER_DATE": "186", "PAYMENT_NUMBER_NUMBER": "6414", "PAYMENT_NUMBER_TYPE": "V", "PAYMENT_YEAR": "2013", "RECORD_TYPE": "2", "SE_BUSINESS_DATE": "2013185", "SERVICE_AGENT_MERCHANT_ID": "", "SERVICE_FEE_AMOUNT": "000515{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": "STORE 7", "SOC_AMOUNT": "0000038012P", "SOC_INVOICE_NUMBER": "185127", "TRACKING_ID": "185001127", "TRACKING_ID_DATE": "185", "TRACKING_ID_PCID": "001127" },
    { "AMEX_GROSS_AMOUNT": "0000000597O", "AMEX_PAYEE_NUMBER": "1116754639", "AMEX_PROCESS_DATE": "2013185", "AMEX_ROC_COUNT": "0000D", "AMEX_ROC_COUNT_POA": "000000D", "AMEX_SE_NUMBER": "1116754639", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": "10", "DISCOUNT_AMOUNT": "00000020}", "DISCOUNT_RATE": "02850", "NET_SOC_AMOUNT": "0000000597O", "OPTIMA_DIVIDEND_AMOUNT": "000000{", "OPTIMA_DIVIDEND_RATE": "00000", "OPTIMA_GROSS_AMOUNT": "0000000000{", "OPTIMA_ROC_COUNT": "0000{", "PAYMENT_NUMBER": "186V6415", "PAYMENT_NUMBER_DATE": "186", "PAYMENT_NUMBER_NUMBER": "6415", "PAYMENT_NUMBER_TYPE": "V", "PAYMENT_YEAR": "2013", "RECORD_TYPE": "2", "SE_BUSINESS_DATE": "2013185", "SERVICE_AGENT_MERCHANT_ID": "", "SERVICE_FEE_AMOUNT": "000020{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": "STORE 8", "SOC_AMOUNT": "0000000597O", "SOC_INVOICE_NUMBER": "185129", "TRACKING_ID": "185001129", "TRACKING_ID_DATE": "185", "TRACKING_ID_PCID": "001129" },
    { "AMEX_GROSS_AMOUNT": "0000035985D", "AMEX_PAYEE_NUMBER": "1116764380", "AMEX_PROCESS_DATE": "2013186", "AMEX_ROC_COUNT": "0009D", "AMEX_ROC_COUNT_POA": "000009D", "AMEX_SE_NUMBER": "1116764380", "CPC_INDICATOR": "", "DETAIL_RECORD_TYPE": "10", "DISCOUNT_AMOUNT": "00001025F", "DISCOUNT_RATE": "02850", "NET_SOC_AMOUNT": "0000034959H", "OPTIMA_DIVIDEND_AMOUNT": "000000{", "OPTIMA_DIVIDEND_RATE": "00000", "OPTIMA_GROSS_AMOUNT": "0000000000{", "OPTIMA_ROC_COUNT": "0000{", "PAYMENT_NUMBER": "186S0225", "PAYMENT_NUMBER_DATE": "186", "PAYMENT_NUMBER_NUMBER": "0225", "PAYMENT_NUMBER_TYPE": "S", "PAYMENT_YEAR": "2013", "RECORD_TYPE": "2", "SE_BUSINESS_DATE": "2013186", "SERVICE_AGENT_MERCHANT_ID": "", "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": "STORE 9", "SOC_AMOUNT": "0000035985D", "SOC_INVOICE_NUMBER": "000425", "TRACKING_ID": "186098799", "TRACKING_ID_DATE": "186", "TRACKING_ID_PCID": "098799" }
  ],
  "CHARGEBACK_DETAIL": [
    { "AMEX_PAYEE_NUMBER": "1116725407", "AMEX_PROCESS_DATE": "2013186", "AMEX_SE_NUMBER": "1116725407", "CHARGEBACK_AMOUNT": "00067203Q", "CHARGEBACK_REASON": "INVALID SUBMISSION DATA. PLEASE CORRECT AND RESUBMIT.", "DETAIL_RECORD_TYPE": "20", "DISCOUNT_AMOUNT": "00001915L", "DISCOUNT_RATE": "02850", "NET_CHARGEBACK_AMOUNT": "00065288N", "PAYMENT_NUMBER": "186V6412", "PAYMENT_NUMBER_DATE": "186", "PAYMENT_NUMBER_NUMBER": "6412", "PAYMENT_NUMBER_TYPE": "V", "PAYMENT_YEAR": "2013", "RECORD_TYPE": "2", "SE_BUSINESS_DATE": "2013186", "SERVICE_AGENT_MERCHANT_ID": "", "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": "STORE 6", "SOC_AMOUNT": "0000067203Q", "SOC_INVOICE_NUMBER": "186375" },
    { "AMEX_PAYEE_NUMBER": "1116725407", "AMEX_PROCESS_DATE": "2013185", "AMEX_SE_NUMBER": "1116725407", "CHARGEBACK_AMOUNT": "00040963K", "CHARGEBACK_REASON": "INVALID SUBMISSION DATA. PLEASE CORRECT AND RESUBMIT.", "DETAIL_RECORD_TYPE": "20", "DISCOUNT_AMOUNT": "00001167N", "DISCOUNT_RATE": "02850", "NET_CHARGEBACK_AMOUNT": "00039795P", "PAYMENT_NUMBER": "186V6412", "PAYMENT_NUMBER_DATE": "186", "PAYMENT_NUMBER_NUMBER": "6412", "PAYMENT_NUMBER_TYPE": "V", "PAYMENT_YEAR": "2013", "RECORD_TYPE": "2", "SE_BUSINESS_DATE": "2013185", "SERVICE_AGENT_MERCHANT_ID": "", "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": "STORE 6", "SOC_AMOUNT": "0000040963K", "SOC_INVOICE_NUMBER": "185375" },
    { "AMEX_PAYEE_NUMBER": "1116725407", "AMEX_PROCESS_DATE": "2013185", "AMEX_SE_NUMBER": "1116725407", "CHARGEBACK_AMOUNT": "00020632O", "CHARGEBACK_REASON": "INVALID SUBMISSION DATA. PLEASE CORRECT AND RESUBMIT.", "DETAIL_RECORD_TYPE": "20", "DISCOUNT_AMOUNT": "00000588}", "DISCOUNT_RATE": "02850", "NET_CHARGEBACK_AMOUNT": "00020044O", "PAYMENT_NUMBER": "186V6412", "PAYMENT_NUMBER_DATE": "186", "PAYMENT_NUMBER_NUMBER": "6412", "PAYMENT_NUMBER_TYPE": "V", "PAYMENT_YEAR": "2013", "RECORD_TYPE": "2", "SE_BUSINESS_DATE": "2013185", "SERVICE_AGENT_MERCHANT_ID": "", "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": "STORE 6", "SOC_AMOUNT": "0000020632O", "SOC_INVOICE_NUMBER": "185375" },
    { "AMEX_PAYEE_NUMBER": "1116726140", "AMEX_PROCESS_DATE": "2013185", "AMEX_SE_NUMBER": "1116726140", "CHARGEBACK_AMOUNT": "00000367G", "CHARGEBACK_REASON": "INVALID SUBMISSION DATA. PLEASE CORRECT AND RESUBMIT.", "DETAIL_RECORD_TYPE": "20", "DISCOUNT_AMOUNT": "00000010E", "DISCOUNT_RATE": "02850", "NET_CHARGEBACK_AMOUNT": "00000357B", "PAYMENT_NUMBER": "186V6414", "PAYMENT_NUMBER_DATE": "186", "PAYMENT_NUMBER_NUMBER": "6414", "PAYMENT_NUMBER_TYPE": "V", "PAYMENT_YEAR": "2013", "RECORD_TYPE": "2", "SE_BUSINESS_DATE": "2013185", "SERVICE_AGENT_MERCHANT_ID": "", "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": "STORE 7", "SOC_AMOUNT": "0000000367G", "SOC_INVOICE_NUMBER": "185127" },
    { "AMEX_PAYEE_NUMBER": "1116754639", "AMEX_PROCESS_DATE": "2013185", "AMEX_SE_NUMBER": "1116754639", "CHARGEBACK_AMOUNT": "00000052I", "CHARGEBACK_REASON": "INVALID SUBMISSION DATA. PLEASE CORRECT AND RESUBMIT.", "DETAIL_RECORD_TYPE": "20", "DISCOUNT_AMOUNT": "00000001E", "DISCOUNT_RATE": "02850", "NET_CHARGEBACK_AMOUNT": "00000051D", "PAYMENT_NUMBER": "186V6415", "PAYMENT_NUMBER_DATE": "186", "PAYMENT_NUMBER_NUMBER": "6415", "PAYMENT_NUMBER_TYPE": "V", "PAYMENT_YEAR": "2013", "RECORD_TYPE": "2", "SE_BUSINESS_DATE": "2013185", "SERVICE_AGENT_MERCHANT_ID": "", "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": "STORE 8", "SOC_AMOUNT": "0000000597O", "SOC_INVOICE_NUMBER": "185129" }
  ],
  "ADJUSTMENT_DETAIL": [
    { "ADJUSTMENT_AMOUNT": "00000123N", "ADJUSTMENT_NUMBER": "258226", "ADJUSTMENT_REASON": "DEBIT ADJUSTMENT-NO REPLY RECEIVED TO OUR INQUIRY", "AMEX_PAYEE_NUMBER": "1116725407", "AMEX_PROCESS_DATE": "2013186", "AMEX_SE_NUMBER": "1116725407", "CARDMEMBER_NUMBER": "00371511XXXXX2097", "DETAIL_RECORD_TYPE": "30", "DISCOUNT_AMOUNT": "00000000{", "DISCOUNT_RATE": "02850", "NET_ADJUSTMENT_AMOUNT": "00000123N", "PAYMENT_NUMBER": "186V6412", "PAYMENT_NUMBER_DATE": "186", "PAYMENT_NUMBER_NUMBER": "6412", "PAYMENT_NUMBER_TYPE": "V", "PAYMENT_YEAR": "2013", "RECORD_TYPE": "2", "SERVICE_AGENT_MERCHANT_ID": "", "SERVICE_FEE_AMOUNT": "000000{", "SERVICE_FEE_RATE": "00000", "SE_UNIT_NUMBER": "STORE 6" }
  ],
  "OTHER_DETAIL": [
    { "AMEX_PAYEE_NUMBER": "1116764380", "AMEX_PROCESS_DATE": "2013186", "AMEX_SE_NUMBER": "1116764380", "ASSET_BILLING_AMOUNT": "00000000{", "ASSET_BILLING_DESCRIPTION": "", "ASSET_BILLING_TAX": "00000000{", "DETAIL_RECORD_TYPE": "50", "OTHER_FEE_AMOUNT": "00000005O", "OTHER_FEE_DESCRIPTION": "NON-SWIPED ADJUSTMENT, AMOUNT 176.46, COUNT 2", "PAY_IN_GROSS_INDICATOR": "", "PAYMENT_NUMBER": "6S022581", "PAYMENT_NUMBER_DATE": "6S0", "PAYMENT_NUMBER_NUMBER": "2581", "PAYMENT_NUMBER_TYPE": "2", "PAYMENT_YEAR": "2018", "RECORD_TYPE": "2", "SERVICE_AGENT_MERCHANT_ID": "", "SE_UNIT_NUMBER": "0000007800", "TAKE_ONE_COMMISSION_AMOUNT": "00000000{", "TAKE_ONE_DESCRIPTION": "" },
    { "AMEX_PAYEE_NUMBER": "1116764380", "AMEX_PROCESS_DATE": "2013186", "AMEX_SE_NUMBER": "1116764380", "ASSET_BILLING_AMOUNT": "00000000{", "ASSET_BILLING_DESCRIPTION": "", "ASSET_BILLING_TAX": "00000000{", "DETAIL_RECORD_TYPE": "50", "OTHER_FEE_AMOUNT": "000000050", "OTHER_FEE_DESCRIPTION": "NONCOMPLIANCE FEE(S) TOTAL CNT 2 AMOUNT 207.71", "PAY_IN_GROSS_INDICATOR": "", "PAYMENT_NUMBER": "6S022581", "PAYMENT_NUMBER_DATE": "6S0", "PAYMENT_NUMBER_NUMBER": "2581", "PAYMENT_NUMBER_TYPE": "2", "PAYMENT_YEAR": "2018", "RECORD_TYPE": "2", "SERVICE_AGENT_MERCHANT_ID": "", "SE_UNIT_NUMBER": "0000007800", "TAKE_ONE_COMMISSION_AMOUNT": "00000000{", "TAKE_ONE_DESCRIPTION": "" }

  ]
}
