use strict;
use warnings;

use Test::More tests=>5;


BEGIN {#1
    use_ok( 'Graph::Dijkstra' ) || print "Bail out!\n";
}

{#tests 2-5

	my $graph = Graph::Dijsktra->new();
	ok(defined($graph), 'Dijkstra->new()');
	
	$graph->node('A', 'one');
	$graph->node('B', 'two');
	$graph->node('C', 'three');
	$graph->node('D', 'four');
	$graph->node('E', 'five');
	$graph->node('F', 'six');
	$graph->node('G', 'seven');
	$graph->node('H', 'eight');
	$graph->node('I', 'nine');
	$graph->node('J', 'ten');
	$graph->node('K', 'eleven');
	$graph->node('L', 'twelve');
	$graph->node('M', 'thirteen');
	$graph->node('N', 'fourteen');
	
	
	$graph->node('O', 'fifteen');
	$graph->node('P', 'sixteen');
	$graph->node('Q', 'seventeen');
	
	$graph->node('R', 'eighteen');
	$graph->node('S', 'ninteen');
	$graph->node('T', 'twenty');
	$graph->node('U', 'twenty-one');
	$graph->node('V', 'twenty-two');
	$graph->node('W', 'twenty-three');
	$graph->node('X', 'twenty-four');
	$graph->node('W', 'twenty-five');
	$graph->node('Z', 'twenty-six');
	
	$graph->edge('A','B',4);
	$graph->edge('A','D',3);
	$graph->edge('A','E',7);
	$graph->edge('A','F',5);
	$graph->edge('B','C',7);
	$graph->edge('B','F',2);
	$graph->edge('C','F',3);
	$graph->edge('C','G',5);
	$graph->edge('D','E',5);
	$graph->edge('D','H',5);
	$graph->edge('E','F',3);
	$graph->edge('E','H',2);
	$graph->edge('F','G',4);
	$graph->edge('F','K',5);
	$graph->edge('G','K',2);
	$graph->edge('H','L',6);
	$graph->edge('I','J',2);
	$graph->edge('I','L',4);
	$graph->edge('I','M',7);
	$graph->edge('J','K',9);
	$graph->edge('K','N',6);
	$graph->edge('M','N',3);
	
	$graph->edge('N','O',3);
	$graph->edge('O','P',3);
	$graph->edge('P','Q',4);
	$graph->edge('Q','O',5);
	
	$graph->edge('Q','R',2);
	$graph->edge('N','R',2);
	$graph->edge('R','S',3);
	$graph->edge('S','T',4);
	$graph->edge('T','U',5);
	$graph->edge('U','V',4);
	$graph->edge('V','W',3);
	$graph->edge('W','X',2);
	$graph->edge('X','Y',1);
	$graph->edge('Y','Z',2);
	$graph->edge('A','Z',7);
	
	
	
	my %solutionMatrix = ();
	
	my $graphMinMax = $graph->vertexCenter(\%solutionMatrix);
	ok($graphMinMax == 23, '$graph->vertexCenter(\%solutionMatrix) == 23');
	
	my @nodeList = (sort keys %{$solutionMatrix{row}});
	ok(scalar(@nodeList) == 26, '@nodeList = (sort keys %{$solutionMatrix{row}}) contains 26 nodes');
	
	my $filename = 't/data/APSP.csv';
	
	$graph->outputAPSPmatrixtoCSV(\%solutionMatrix, $filename);
	ok(-e $filename, "'$filename' created");
	
	unlink($filename);

}