# NAME

Graphics::ColorNames::Windows - Windows color names and equivalent RGB values

# VERSION

version v3.3.1

# SYNOPSIS

```
require Graphics::ColorNames::Windows;

$NameTable = Graphics::ColorNames::Windows->NamesRgbTable();
$RgbBlack  = $NameTable->{black};
```

# DESCRIPTION

This module defines color names and their associated RGB values used in
Microsoft Windows.

# SEE ALSO

[Graphics::ColorNames](https://metacpan.org/pod/Graphics::ColorNames)

[Graphics::ColorNames::IE](https://metacpan.org/pod/Graphics::ColorNames::IE)

# SOURCE

The development version is on github at [https://github.com/robrwo/Graphics-ColorNames-Windows](https://github.com/robrwo/Graphics-ColorNames-Windows)
and may be cloned from [git://github.com/robrwo/Graphics-ColorNames-Windows.git](git://github.com/robrwo/Graphics-ColorNames-Windows.git)

# BUGS

Please report any bugs or feature requests on the bugtracker website
[https://github.com/robrwo/Graphics-ColorNames-Windows/issues](https://github.com/robrwo/Graphics-ColorNames-Windows/issues)

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

# AUTHOR

Robert Rothenberg <rrwo@cpan.org>

# COPYRIGHT AND LICENSE

Robert Rothenberg has dedicated the work to the Commons by waiving all of his
or her rights to the work worldwide under copyright law and all related or
neighboring legal rights he or she had in the work, to the extent allowable by
law.

Works under CC0 do not require attribution. When citing the work, you should
not imply endorsement by the author.
