/**
 * pdfXtk-Extras - PDF Extraction Toolkit Extras
 * Copyright (c) by the authors/contributors.  All rights reserved.
 * This project includes code from PDFBox and TouchGraph.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the names pdfXtk or PDF Extraction Toolkit; nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * http://pdfxtk.sourceforge.net
 *
 */
package at.ac.tuwien.dbai.pdfwrap.util;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import at.ac.tuwien.dbai.pdfwrap.model.document.GenericSegment;
import at.ac.tuwien.dbai.pdfwrap.table.CandidateColumn;
import at.ac.tuwien.dbai.pdfwrap.table.OrderedTable;
import at.ac.tuwien.dbai.pdfwrap.table.TableColumn;
import at.ac.tuwien.dbai.pdfwrap.table.TableRow;
import at.ac.tuwien.dbai.pdfwrap.utils.SegmentUtils;

public class ExtraUtils 
{
	public static List<CandidateColumn> getCandidateColumns(List<GenericSegment> l)
	{
		List<CandidateColumn> retVal = new ArrayList<CandidateColumn>();
		Iterator<GenericSegment> iter = l.iterator();
		while (iter.hasNext())
		{
			GenericSegment thisSegment = iter.next();
			if (thisSegment.getClass() == CandidateColumn.class)
				retVal.add((CandidateColumn)thisSegment);
		}
		return retVal;
	}
	
	public static List<OrderedTable> getOrderedTables(List<GenericSegment> l)
	{
		List<OrderedTable> retVal = new ArrayList<OrderedTable>();
		Iterator<GenericSegment> iter = l.iterator();
		while (iter.hasNext())
		{
			GenericSegment thisSegment = iter.next();
			if (thisSegment.getClass() == OrderedTable.class)
				retVal.add((OrderedTable)thisSegment);
		}
		return retVal;
	}
	
	public static List<TableColumn> getTableColumns(List<GenericSegment> l)
	{
		List<TableColumn> retVal = new ArrayList<TableColumn>();
		Iterator<GenericSegment> iter = l.iterator();
		while (iter.hasNext())
		{
			GenericSegment thisSegment = iter.next();
			if (thisSegment.getClass() == TableColumn.class)
				retVal.add((TableColumn)thisSegment);
		}
		return retVal;
	}
	
	public static List<TableRow> getTableRows(List<GenericSegment> l)
	{
		List<TableRow> retVal = new ArrayList<TableRow>();
		Iterator<GenericSegment> iter = l.iterator();
		while (iter.hasNext())
		{
			GenericSegment thisSegment = iter.next();
			if (thisSegment.getClass() == TableRow.class)
				retVal.add((TableRow)thisSegment);
		}
		return retVal;
	}
	
	// 23.08.10: The following methods from http://snippets.dzone.com/posts/show/2936
	
	public static BufferedImage rotate90CW(BufferedImage bi) // -90deg
	{
		int width = bi.getWidth();
		int height = bi.getHeight();
		
		// changed 14.12.10
		BufferedImage biFlip = new BufferedImage(height, width, BufferedImage.TYPE_INT_RGB);//bi.getType());
		
		for(int i=0; i<width; i++)
			for(int j=0; j<height; j++)
				biFlip.setRGB(j, width-1-i, bi.getRGB(i, j));
//				biFlip.setRGB(height-1-j, width-1-i, bi.getRGB(i, j)); -- this is a flip!
		
		return biFlip;
	}

	
	public static BufferedImage rotate90ACW(BufferedImage bi) // 90deg
	{
		int width = bi.getWidth();
		int height = bi.getHeight();
		
		BufferedImage biFlip = new BufferedImage(height, width, BufferedImage.TYPE_INT_RGB);//bi.getType());
		
		for(int i=0; i<width; i++)
			for(int j=0; j<height; j++)
				biFlip.setRGB(height-1-j, i, bi.getRGB(i, j));
//				biFlip.setRGB(j, i, bi.getRGB(i, j));
		
		return biFlip;
	}
	
	public static void mergeIntersectingBlockAreas(List<? extends GenericSegment> sl)
    {
    	for (int m = 0; m < sl.size(); m ++)
    	{
    		GenericSegment seg1 = (GenericSegment)sl.get(m);
    		{
    			for (int n = 0; n < sl.size(); n ++)
    			{
    				GenericSegment seg2 = (GenericSegment)sl.get(n);
    				if (m != n && SegmentUtils.intersects(seg1, seg2))
    				{
    					seg1.growBoundingBox(seg2);
//    					seg1.getItems().addAll(seg2.getItems());
//    					seg1.findBoundingBox();
    					sl.remove(seg2); // removing n
    					if (m > n) m --;
    					// start again with the same m and n = 0;
    					m --;
    					n = sl.size();
    				}
    			}
    		}
    	}
    }
}
