package Net::Amazon::EMR::Ec2InstanceAttributes;
use Moose;
with 'Net::Amazon::EMR::Role::AttrHash';
use Net::Amazon::EMR::Coercions;

has 'AdditionalMasterSecurityGroups' => ( is => 'ro', 
                                          isa => 'Net::Amazon::EMR::Type::ArrayRefofUnconstrainedStr',
                                          coerce => 1,
                                      );

has 'AdditionalSlaveSecurityGroups' => ( is => 'ro', 
                                         isa => 'Net::Amazon::EMR::Type::ArrayRefofUnconstrainedStr',
                                         coerce => 1,
                                     );

has 'Ec2AvailabilityZone' => ( is => 'ro', 
                               isa => 'Str' );

has 'Ec2KeyName' => ( is => 'ro', 
                      isa => 'Str' );

has 'Ec2SubnetId' => ( is => 'ro', 
                       isa => 'Str' );


has 'EmrManagedSlaveSecurityGroup' => ( is => 'ro', 
                                        isa => 'Str' );

has 'IamInstanceProfile' => ( is => 'ro', 
                              isa => 'Str' );

has 'ServiceAccessSecurityGroup' => ( is => 'ro', 
                                      isa => 'Str' );


__PACKAGE__->meta->make_immutable();

1;

__END__

=head1 NAME

Net::Amazon::EMR::Ec2InstanceAttributes

=head1 DESCRIPTION

Implements the Ec2InstanceAttributes data type described at L<http://docs.amazonwebservices.com/ElasticMapReduce/latest/APIReference/API_Ec2InstanceAttributes.html>.

=head1 AUTHOR

Jon Schutz 

L<http://notes.jschutz.net>

=head1 DOCUMENTATION, LICENSE AND COPYRIGHT

See L<Net::Amazon::EMR>.

=cut
