/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.http;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.couchbase.mock.Bucket;
import org.couchbase.mock.CouchbaseMock;
import org.couchbase.mock.http.StateGrabber;

public class BucketsStreamingHandler
implements Observer {
    private final OutputStream output;
    private final Bucket bucket;
    private final CouchbaseMock.HarakiriMonitor monitor;
    private final CountDownLatch completed;
    private final Lock updateHandlerLock;

    public BucketsStreamingHandler(CouchbaseMock.HarakiriMonitor monitor, Bucket bucket, OutputStream output) {
        this.output = output;
        this.bucket = bucket;
        this.monitor = monitor;
        this.completed = new CountDownLatch(1);
        this.updateHandlerLock = new ReentrantLock();
    }

    private byte[] getConfigBytes() {
        StringWriter sw = new StringWriter();
        sw.append(StateGrabber.getBucketJSON(this.bucket));
        sw.append(StateGrabber.getStreamDelimiter());
        return sw.toString().getBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Observable o, Object arg) {
        this.updateHandlerLock.lock();
        try {
            this.output.write(this.getConfigBytes());
            this.output.flush();
        }
        catch (IOException ex) {
            this.completed.countDown();
        }
        finally {
            this.updateHandlerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startStreaming() throws IOException, InterruptedException {
        this.bucket.configReadLock();
        byte[] configBytes = this.getConfigBytes();
        this.updateHandlerLock.lock();
        if (this.monitor != null) {
            this.monitor.addObserver(this);
        }
        this.bucket.configReadUnlock();
        try {
            this.output.write(configBytes);
            this.output.flush();
        }
        finally {
            this.updateHandlerLock.unlock();
        }
        this.completed.await();
        this.output.close();
    }
}

