# Generated by default/object.tt
package Paws::GreengrassV2::DeploymentPolicies;
  use Moose;
  has ComponentUpdatePolicy => (is => 'ro', isa => 'Paws::GreengrassV2::DeploymentComponentUpdatePolicy', request_name => 'componentUpdatePolicy', traits => ['NameInRequest']);
  has ConfigurationValidationPolicy => (is => 'ro', isa => 'Paws::GreengrassV2::DeploymentConfigurationValidationPolicy', request_name => 'configurationValidationPolicy', traits => ['NameInRequest']);
  has FailureHandlingPolicy => (is => 'ro', isa => 'Str', request_name => 'failureHandlingPolicy', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::GreengrassV2::DeploymentPolicies

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GreengrassV2::DeploymentPolicies object:

  $service_obj->Method(Att1 => { ComponentUpdatePolicy => $value, ..., FailureHandlingPolicy => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GreengrassV2::DeploymentPolicies object:

  $result = $service_obj->Method(...);
  $result->Att1->ComponentUpdatePolicy

=head1 DESCRIPTION

Contains information about policies that define how a deployment
updates components and handles failure.

=head1 ATTRIBUTES


=head2 ComponentUpdatePolicy => L<Paws::GreengrassV2::DeploymentComponentUpdatePolicy>

The component update policy for the configuration deployment. This
policy defines when it's safe to deploy the configuration to devices.


=head2 ConfigurationValidationPolicy => L<Paws::GreengrassV2::DeploymentConfigurationValidationPolicy>

The configuration validation policy for the configuration deployment.
This policy defines how long each component has to validate its
configure updates.


=head2 FailureHandlingPolicy => Str

The failure handling policy for the configuration deployment. This
policy defines what to do if the deployment fails.

Default: C<ROLLBACK>



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GreengrassV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

