# Generated by default/object.tt
package Paws::WAFV2::JsonMatchPattern;
  use Moose;
  has All => (is => 'ro', isa => 'Paws::WAFV2::All');
  has IncludedPaths => (is => 'ro', isa => 'ArrayRef[Str|Undef]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::WAFV2::JsonMatchPattern

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::WAFV2::JsonMatchPattern object:

  $service_obj->Method(Att1 => { All => $value, ..., IncludedPaths => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::WAFV2::JsonMatchPattern object:

  $result = $service_obj->Method(...);
  $result->Att1->All

=head1 DESCRIPTION

The patterns to look for in the JSON body. WAF inspects the results of
these pattern matches against the rule inspection criteria. This is
used with the FieldToMatch option C<JsonBody>.

=head1 ATTRIBUTES


=head2 All => L<Paws::WAFV2::All>

Match all of the elements. See also C<MatchScope> in JsonBody.

You must specify either this setting or the C<IncludedPaths> setting,
but not both.


=head2 IncludedPaths => ArrayRef[Str|Undef]

Match only the specified include paths. See also C<MatchScope> in
JsonBody.

Provide the include paths using JSON Pointer syntax. For example,
C<"IncludedPaths": ["/dogs/0/name", "/dogs/1/name"]>. For information
about this syntax, see the Internet Engineering Task Force (IETF)
documentation JavaScript Object Notation (JSON) Pointer
(https://tools.ietf.org/html/rfc6901).

You must specify either this setting or the C<All> setting, but not
both.

Don't use this option to include all paths. Instead, use the C<All>
setting.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::WAFV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

