/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics;

import java.io.IOException;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSBoolean;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.function.PDFunction;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpaceFactory;

public class PDShading
implements COSObjectable {
    private COSDictionary DictShading;
    private COSName shadingname;
    public static final String NAME = "Shading";

    public PDShading() {
        this.DictShading = new COSDictionary();
    }

    public PDShading(COSName name, COSDictionary shading) {
        this.DictShading = shading;
        this.shadingname = name;
    }

    public String getName() {
        return NAME;
    }

    public COSBase getCOSObject() {
        return COSName.getPDFName(this.getName());
    }

    public COSName getShadingName() {
        return this.shadingname;
    }

    public int getShadingType() {
        return this.DictShading.getInt("ShadingType");
    }

    public PDColorSpace getColorSpace() throws IOException {
        return PDColorSpaceFactory.createColorSpace(this.DictShading.getDictionaryObject("ColorSpace"));
    }

    public boolean getAntiAlias() {
        return this.DictShading.getBoolean("AntiAlias", false);
    }

    public COSArray getCoords() {
        return (COSArray)this.DictShading.getDictionaryObject("Coords");
    }

    public PDFunction getFunction() throws IOException {
        return PDFunction.create(this.DictShading.getDictionaryObject("Function"));
    }

    public COSArray getDomain() {
        return (COSArray)this.DictShading.getDictionaryObject("Domain");
    }

    public COSArray getExtend() {
        COSArray arExtend = (COSArray)this.DictShading.getDictionaryObject("Extend");
        if (arExtend == null) {
            arExtend = new COSArray();
            arExtend.add(COSBoolean.FALSE);
            arExtend.add(COSBoolean.FALSE);
        }
        return arExtend;
    }

    public String toString() {
        String sFunction;
        String sColorSpace;
        try {
            sColorSpace = this.getColorSpace().toString();
        }
        catch (IOException e) {
            sColorSpace = "Failure retrieving ColorSpace: " + e.toString();
        }
        try {
            sFunction = this.getFunction().toString();
        }
        catch (IOException e) {
            sFunction = "n/a";
        }
        String s = "Shading " + this.shadingname + "\n" + "\tShadingType: " + this.getShadingType() + "\n" + "\tColorSpace: " + sColorSpace + "\n" + "\tAntiAlias: " + this.getAntiAlias() + "\n" + "\tCoords: " + this.getCoords().toString() + "\n" + "\tDomain: " + this.getDomain().toString() + "\n" + "\tFunction: " + sFunction + "\n" + "\tExtend: " + this.getExtend().toString() + "\n" + "\tRaw Value:\n" + this.DictShading.toString();
        return s;
    }
}

