/*
 * Decompiled with CFR 0.152.
 */
package org.gagravarr.ogg;

import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.gagravarr.ogg.OggFile;
import org.gagravarr.ogg.OggPacket;
import org.gagravarr.ogg.OggPacketReader;

public class TestReadSkipping
extends TestCase {
    private InputStream getTestFile() throws IOException {
        return ((Object)((Object)this)).getClass().getResourceAsStream("/testVORBIS.ogg");
    }

    public void testSkipToSequence() throws Exception {
        OggFile ogg = new OggFile(this.getTestFile());
        OggPacketReader r = ogg.getPacketReader();
        r.skipToSequenceNumber(-1, 0);
        TestReadSkipping.assertEquals(null, (Object)r.getNextPacket());
        ogg = new OggFile(this.getTestFile());
        r = ogg.getPacketReader();
        r.skipToSequenceNumber(74691676, 100);
        TestReadSkipping.assertEquals(null, (Object)r.getNextPacket());
        ogg = new OggFile(this.getTestFile());
        r = ogg.getPacketReader();
        r.skipToSequenceNumber(74691676, 0);
        OggPacket p = r.getNextPacket();
        TestReadSkipping.assertNotNull((Object)p);
        TestReadSkipping.assertEquals((int)74691676, (int)p.getSid());
        TestReadSkipping.assertEquals((int)0, (int)p.getSequenceNumber());
        p = r.getNextPacket();
        TestReadSkipping.assertNotNull((Object)p);
        TestReadSkipping.assertEquals((int)74691676, (int)p.getSid());
        TestReadSkipping.assertEquals((int)1, (int)p.getSequenceNumber());
        ogg = new OggFile(this.getTestFile());
        r = ogg.getPacketReader();
        r.skipToSequenceNumber(74691676, 2);
        p = r.getNextPacket();
        TestReadSkipping.assertNotNull((Object)p);
        TestReadSkipping.assertEquals((int)74691676, (int)p.getSid());
        TestReadSkipping.assertEquals((int)2, (int)p.getSequenceNumber());
        p = r.getNextPacket();
        TestReadSkipping.assertNotNull((Object)p);
        TestReadSkipping.assertEquals((int)74691676, (int)p.getSid());
        TestReadSkipping.assertEquals((int)2, (int)p.getSequenceNumber());
    }

    public void testSkipToGranuleExact() throws Exception {
        OggFile ogg = new OggFile(this.getTestFile());
        OggPacketReader r = ogg.getPacketReader();
        r.skipToGranulePosition(-1, 0L);
        TestReadSkipping.assertEquals(null, (Object)r.getNextPacket());
        ogg = new OggFile(this.getTestFile());
        r = ogg.getPacketReader();
        r.skipToGranulePosition(74691676, 974010L);
        TestReadSkipping.assertEquals(null, (Object)r.getNextPacket());
        ogg = new OggFile(this.getTestFile());
        r = ogg.getPacketReader();
        r.skipToGranulePosition(74691676, 0L);
        OggPacket p = r.getNextPacket();
        TestReadSkipping.assertNotNull((Object)p);
        TestReadSkipping.assertEquals((int)74691676, (int)p.getSid());
        TestReadSkipping.assertEquals((long)0L, (long)p.getGranulePosition());
        TestReadSkipping.assertEquals((int)0, (int)p.getSequenceNumber());
        p = r.getNextPacket();
        TestReadSkipping.assertNotNull((Object)p);
        TestReadSkipping.assertEquals((int)74691676, (int)p.getSid());
        TestReadSkipping.assertEquals((long)0L, (long)p.getGranulePosition());
        TestReadSkipping.assertEquals((int)1, (int)p.getSequenceNumber());
        ogg = new OggFile(this.getTestFile());
        r = ogg.getPacketReader();
        r.skipToGranulePosition(74691676, 960L);
        p = r.getNextPacket();
        TestReadSkipping.assertNotNull((Object)p);
        TestReadSkipping.assertEquals((int)74691676, (int)p.getSid());
        TestReadSkipping.assertEquals((long)960L, (long)p.getGranulePosition());
        TestReadSkipping.assertEquals((int)2, (int)p.getSequenceNumber());
        p = r.getNextPacket();
        TestReadSkipping.assertNotNull((Object)p);
        TestReadSkipping.assertEquals((int)74691676, (int)p.getSid());
        TestReadSkipping.assertEquals((long)960L, (long)p.getGranulePosition());
        TestReadSkipping.assertEquals((int)2, (int)p.getSequenceNumber());
        ogg = new OggFile(this.getTestFile());
        r = ogg.getPacketReader();
        r.skipToGranulePosition(74691676, 801L);
        p = r.getNextPacket();
        TestReadSkipping.assertNotNull((Object)p);
        TestReadSkipping.assertEquals((int)74691676, (int)p.getSid());
        TestReadSkipping.assertEquals((long)960L, (long)p.getGranulePosition());
        TestReadSkipping.assertEquals((int)2, (int)p.getSequenceNumber());
        p = r.getNextPacket();
        TestReadSkipping.assertNotNull((Object)p);
        TestReadSkipping.assertEquals((int)74691676, (int)p.getSid());
        TestReadSkipping.assertEquals((long)960L, (long)p.getGranulePosition());
        TestReadSkipping.assertEquals((int)2, (int)p.getSequenceNumber());
    }
}

