/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.encoding;

import java.io.IOException;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.encoding.Encoding;
import org.apache.pdfbox.encoding.MacRomanEncoding;
import org.apache.pdfbox.encoding.PdfDocEncoding;
import org.apache.pdfbox.encoding.StandardEncoding;
import org.apache.pdfbox.encoding.WinAnsiEncoding;

public class EncodingManager {
    public static final EncodingManager INSTANCE = new EncodingManager();

    public Encoding getStandardEncoding() {
        return StandardEncoding.INSTANCE;
    }

    public Encoding getEncoding(COSName name) throws IOException {
        if (COSName.STANDARD_ENCODING.equals(name)) {
            return StandardEncoding.INSTANCE;
        }
        if (COSName.WIN_ANSI_ENCODING.equals(name)) {
            return WinAnsiEncoding.INSTANCE;
        }
        if (COSName.MAC_ROMAN_ENCODING.equals(name)) {
            return MacRomanEncoding.INSTANCE;
        }
        if (COSName.PDF_DOC_ENCODING.equals(name)) {
            return PdfDocEncoding.INSTANCE;
        }
        throw new IOException("Unknown encoding for '" + name.getName() + "'");
    }
}

