package enum::prefix;
use warnings;
our $VERSION = '0.01';
my $ident = '[^\W_0-9]\w*';
no strict 'refs';

#example:
# use enum::prefix BUG => qw(_STATUS CLOSE FIXED REOPEN);
# will export BUG_CLOSE BUG_FIXED BUG_REOPEN and BUG_STATUS
# BUG_STATUS(1) return "FIXED"

sub import
{
	my $class = shift;
	my $prefix = shift;
	my $name_sub_suffix = shift;
	@_ or return;

	my $pkg = caller() . '::';

	my $index = 0;

	my @enum;
	for my $name (@_)
	{
		if ( $name =~ /^$ident$/o )
		{
			my $n = $index;
			$index++;
			*{ $pkg . $prefix . '_' . $name } = sub { $n };
			$enum[$n] = $name;
		}
	}

	*{$pkg. $prefix . $name_sub_suffix } = sub($) { $enum[ $_[0] ] };
}

1;
