/*
 * Copyright (c) 2004 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 * $Id: t-ringins.h,v 1.1 2004/09/10 18:53:13 ca Exp $
 */

#include "sm/generic.h"
#include "sm/types.h"
#include "sm/str.h"
#include "sm/ring.h"

struct aq_rcpt_S
{
	sm_str_P		 aqr_domain;
	sm_ring_T		 aqr_ss_link;
};
typedef struct aq_rcpt_S	aq_rcpt_T, *aq_rcpt_P;

#define AQR_SS2R(aq_rcpt)	(&((aq_rcpt)->aqr_ss_link))
#define AQR_R2SS(ring)	SM_RING_EMBED((ring), aq_rcpt_T, aqr_ss_link)
#define AQR_SS_INIT(aq_rcpt)	SM_RING_INIT(AQR_SS2R(aq_rcpt))
#define AQR_SS_APP(aq_rcpt, aq_rcpt_nxt)	SM_RING_APPEND(AQR_SS2R(aq_rcpt), AQR_SS2R(aq_rcpt_nxt))
#define AQR_SS_PRE(aq_rcpt, aq_rcpt_nxt)	SM_RING_PREPEND(AQR_SS2R(aq_rcpt), AQR_SS2R(aq_rcpt_nxt))
#define AQR_SS_SUCC(aq_rcpt)	AQR_R2SS(sm_ring_succ(AQR_SS2R(aq_rcpt)))
#define AQR_SS_PRED(aq_rcpt)	AQR_R2SS(sm_ring_pred(AQR_SS2R(aq_rcpt)))

/* function/macro to compare two ring elements */
#define RING_CMP(el1, el2)	\
	sm_str_casecmp(AQR_R2SS(el1)->aqr_domain, AQR_R2SS(el2)->aqr_domain)

