/*
 * Copyright (c) 2003, 2004 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: logtest2.c,v 1.3 2004/12/29 23:47:29 ca Exp $")
#include "sm/io.h"
#include "sm/error.h"
#include "sm/log.h"
#include "sm/test.h"

#include <fcntl.h>

sm_logcategory_T c2_lcats[] =
{
	{ "init", 	0 },
	{ "config", 	0 },
	{ "comm",	0 },
	{ "sched",	0 },
	{ NULL, 	0 }
};

sm_logmodule_T c2_lmods[] =
{
	{ "comm",	 	0 },
	{ "config",		0 },
	{ "sched",		0 },
	{ NULL, 		0 }
};

#define C2_LCAT_INIT		(&c2_lcats[0])
#define C2_LCAT_COMM		(&c2_lcats[1])
#define C2_LCAT_SCHED		(&c2_lcats[2])

/* Backwards compatibility. */
#define C2_LCAT_GENERAL	QMGLOGCATEGORY_GENERAL

#define C2_LMOD_COMM		(&c2_lmods[0])
#define C2_LMOD_CONFIG		(&c2_lmods[1])
#define C2_LMOD_SCHED		(&c2_lmods[2])

sm_log_ctx_P	 c2_lctx;
sm_logconfig_P	 c2_lcfg;
int c2_loglevel = 9;

static sm_ret_T
test_init(void)
{
	sm_ret_T ret;

	c2_lctx = NULL;
	c2_lcfg = NULL;
	ret = sm_log_create(NULL, &c2_lctx, &c2_lcfg);
	SM_TEST(sm_is_success(ret));
	if (sm_is_err(ret))
		goto done;
	ret = sm_log_setfp_fd(c2_lctx, smioout, SMIOOUT_FILENO);
	SM_TEST(sm_is_success(ret));
	if (sm_is_err(ret))
		goto done;
	ret = sm_log_setdebuglevel(c2_lctx, c2_loglevel);
	SM_TEST(sm_is_success(ret));
	if (sm_is_err(ret))
		goto done;

  done:
	return ret;
}

static sm_ret_T
test_log(void)
{
	sm_ret_T ret;

	ret = sm_log_write(c2_lctx, C2_LCAT_INIT, C2_LMOD_CONFIG, SM_LOG_INFO,
		8, "test log 2 before reopen");
	SM_TEST(sm_is_success(ret));
	if (sm_is_err(ret))
		goto done;
	ret = sm_log_write(c2_lctx, C2_LCAT_INIT, C2_LMOD_CONFIG, SM_LOG_INFO,
		8, "another test for log still before reopen");
	SM_TEST(sm_is_success(ret));
	if (sm_is_err(ret))
		goto done;

	ret = sm_log_reopen(c2_lctx);
	SM_TEST(sm_is_success(ret));
	if (sm_is_err(ret))
		goto done;
	ret = sm_log_write(c2_lctx, C2_LCAT_INIT, C2_LMOD_CONFIG, SM_LOG_INFO,
		8, "test log 2 after reopen");
	SM_TEST(sm_is_success(ret));
	if (sm_is_err(ret))
		goto done;

  done:
	return ret;
}


int
main(int argc, char *argv[])
{
	int c;
	sm_ret_T ret;

	while ((c = getopt(argc, argv, "?")) != -1)
	{
		switch (c)
		{
#if 0
		  default:
			usage(argv[0]);
			return(1);
#endif /* 0 */
		}
	}

	sm_test_begin(argc, argv, "test log2");

	ret = test_init();
	SM_TEST(sm_is_success(ret));
	if (sm_is_err(ret))
		goto done;

	ret = test_log();
	SM_TEST(sm_is_success(ret));
	if (sm_is_err(ret))
		goto done;

	sm_log_destroy(c2_lctx);
  done:
	return sm_test_end();
}
