/*
 * Copyright (c) 2000-2002 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_IDSTR(id, "@(#)$Id: t-fopen.c,v 1.7 2002/09/19 21:41:04 ca Exp $")

#include "sm/fcntl.h"
#include "sm/io.h"
#include "sm/test.h"

int
main(int argc, char *argv[])
{
	sm_ret_T res;
	ssize_t n;
	int r, m;
	sm_file_T *out;
	char *str = "foo\n";

	sm_test_begin(argc, argv, "test sm_io_open");
	res = sm_io_open(SmStStdio, "foo", SM_IO_WRONLY, &out, SM_IO_WHAT_END);
	SM_TEST(res == SM_SUCCESS);
	SM_TEST(out != NULL);
	if (out != NULL)
	{
		res = sm_io_write(out, (uchar *) str, 4, &n);
		SM_TEST(res == SM_SUCCESS);
		SM_TEST(n == 4);
		r = sm_io_getinfo(out, SM_IO_WHAT_MODE, &m);
		SM_TEST(r == 0);
		SM_TEST(m == SM_IO_WRONLY);
		res = sm_io_close(out);
		SM_TEST(res == SM_SUCCESS);
	}
	return sm_test_end();
}
