#!/bin/sh
# $Id: t-sock-0.sh,v 1.1 2005/08/24 20:56:37 ca Exp $
# Copyright (c) 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# test file operations via network, e.g., timeout
#
test -s stop && exit 1
#
SRV="error.srv"
CLT="error.clt"
# NOTICE: this must be larger than the size of the TCP buffer...
L=1000000
# verbose?
VERBOSE=false
PRG=./t-sock
#
rm -f ${SRV} ${CLT}
${VERBOSE} && echo "server/client: basic test"
${PRG} -s 100 2> ${SRV} &
sleep 1
${PRG} -c 100 2> ${CLT}
wait
sleep 1

rm -f ${SRV} ${CLT}
${VERBOSE} && echo "server/client: too few data: EOF"
${PRG} -s 200 2> ${SRV} &
sleep 1
${PRG} -c 100 2> ${CLT}
wait
if grep 'readsock: EOF' ${SRV}  >/dev/null
then
	${VERBOSE} && echo ok
else
	echo ERROR: expected 'EOF'
	cat ${SRV}
	exit 1
fi
sleep 1

rm -f ${SRV} ${CLT}
${VERBOSE} && echo "server/client: too few data: read timeout"
${PRG} -s 200 2> ${SRV} &
sleep 1
${PRG} -c 100 -d 20 2> ${CLT}
wait
if grep 'readsock: .*type=3' ${SRV}  >/dev/null
then
	${VERBOSE} && echo ok
else
	echo ERROR: expected 'type=3'
	cat ${SRV}
	exit 1
fi
sleep 1

rm -f ${SRV} ${CLT}
${VERBOSE} && echo "server/client: too much data: write error"
${PRG} -s 200 2> ${SRV} &
sleep 1
${PRG} -c ${L} -d 20 2> ${CLT}
wait
if grep 'writesock: .*type=4' ${CLT}  >/dev/null
then
	${VERBOSE} && echo ok
else
	echo ERROR: expected 'type=4'
	cat ${CLT}
	exit 1
fi

rm -f ${SRV} ${CLT}
${VERBOSE} && echo "server/client: write timeout"
${PRG} -s 200 -d 20 2> ${SRV} &
sleep 1
${PRG} -c ${L} -d 20 2> ${CLT}
wait
if grep 'writesock: .*type=3' ${CLT}  >/dev/null
then
	${VERBOSE} && echo ok
else
	echo ERROR: expected 'type=3'
	cat ${CLT}
	exit 1
fi

${VERBOSE} || rm -f ${SRV} ${CLT}
exit 0
