/*
 * Copyright (c) 2004 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: t-strcasecmp.c,v 1.2 2004/09/09 01:37:29 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/memops.h"
#include "sm/rpool.h"
#include "sm/test.h"
#include "sm/str.h"

#include <stdio.h>

#define SMAXLEN	256

static void
test_harness(sm_rpool_P a)
{
	sm_str_P s1, s2, s3;
	size_t len;
	char *src1 = "abCdef";
	char *src2 = "abcDefg";
	char *src3 = "aBcdefh";

	len = strlen(src1) + strlen(src2);
	s1 = s2 = s3 = NULL;
	s1 = sm_str_scpy(a, src1, len);
	SM_TEST(s1 != NULL);
	SM_TEST(sm_str_getlen(s1) == strlen(src1));
	s2 = sm_str_scpy(a, src2, len);
	SM_TEST(s2 != NULL);
	SM_TEST(sm_str_getlen(s2) == strlen(src2));
	s3 = sm_str_scpy(a, src3, len);
	SM_TEST(s3 != NULL);
	SM_TEST(sm_str_getlen(s3) == strlen(src3));

	SM_TEST(sm_str_casecmp(s1, s2) < 0);
	SM_TEST(sm_str_casecmp(s1, s1) == 0);
	SM_TEST(sm_str_casecmp(s2, s1) > 0);

	SM_TEST(sm_str_casecmp(s1, s3) < 0);
	SM_TEST(sm_str_casecmp(s3, s3) == 0);
	SM_TEST(sm_str_casecmp(s3, s1) > 0);

	SM_TEST(sm_str_casecmp(s2, s3) < 0);
	SM_TEST(sm_str_casecmp(s2, s2) == 0);
	SM_TEST(sm_str_casecmp(s3, s2) > 0);

	sm_str_free(s1);
	sm_str_free(s2);
	sm_str_free(s3);
}

int
main(int argc, char *argv[])
{
	sm_rpool_P a;

	sm_test_begin(argc, argv, "test str_casecmp");

	/* create an rpool for entire test */
	a = sm_rpool_new(NULL);
	SM_TEST(a != NULL);
	test_harness(a);
	sm_rpool_delete(a);

	/* test without rpool */
	test_harness(NULL);
	return sm_test_end();
}
