#!/bin/sh
# $Id: t-mts-grey-1.sh,v 1.5 2005/10/21 18:02:20 ca Exp $
# Copyright (c) 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test greylisting; uses greylisting, delay_greylisting_error_until_DATA
# and protected_recipients to test interaction of features.
# uses smtpcnf.sh.
# ----------------------------------------
#
test -s stop && exit 1
#

# this is a "slow" test?
if test X"${SM_NO_SLOW_TEST}" != "X"
then
  echo "$0: SKIPPED {SM_NO_SLOW_TEST}"
  exit 0
fi

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh

SCRIPTS=`cd ${SD} && pwd`
SRCPRG=${STE}/smtpc2

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# cd to right directory (where the programs will be executed).
cd ../qmgr || exit 1

# create empty access map
rm -f ${ACCMAP}
${MM} -t'	' -F ${ACCMAP} < /dev/null

${CAT} > ${SMXCNF} <<EOF
qmgr { Log_Level = 12; wait_for_server=4; wait_for_client=4; }
smar { Log_Level = 14; nameserver = ${NS};
greylisting { grey_wait=10s; grey_expire=30s; }
}
smtpc { Log_Level = 12; remote_port=${SNKPORT}; wait_for_server=4; }
smtps {
Log_Level = 14;
flags = {access,greylisting,delay_greylisting_error_until_DATA,
};
protected_recipients {allow_by={sender}}
daemon_address = localhost:${SRVPORT};
relay_from = "no.host";
relay_to = "local.host";
wait_for_server=4;
}
EOF

# create aliases
${CAT} > ${ALI} <<EOF
abuse:	local:
postmaster:	local:
user:	local:
EOF
# create map
rm -f ${ALIMAP}
${MM} < ${ALI}

${CAT} > ${MT} <<EOF
local.host	[127.0.0.1]
y.z		[127.0.0.1]
local.domain	lmtp:
EOF

# ----------------------------------------
# try to send a message: greylisted twice, then accepted
TEST=1
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
rm -f grey_grey_m.db grey_grey_s.db
ERR=false
SENDER=sender${TEST}@y.z
RCPT="-Runknown@local.domain -Ruser@local.domain"
if ${SHELL} ${SD}/smtpcnf.sh -z -S${SENDER} ${RCPT} -E 0 -X 0 -A 0
then
  sleep 1
  ${GREP} ERROR a0.log s0.log && ERR=true
  if ${SRCPRG} -r ${H}:${SRVPORT} -f"${SENDER}" ${RCPT} > ${CLTL} 2>&1
  then
    # check that no mail has been sent
    ${GREP} "total=0 " ${CLTL} >/dev/null || ERR=true
    ${GREP} ERROR a0.log s0.log && ERR=true
  else
    :
  fi

  sleep 11
  if ${SRCPRG} -r ${H}:${SRVPORT} -f"${SENDER}" ${RCPT} > ${CLTL} 2>&1
  then
    # check that mail has been sent
    ${GREP} "total=1 " ${CLTL} >/dev/null || ERR=true
    ${GREP} ERROR a0.log s0.log && ERR=true
  else
    :
  fi

else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
else
   ${VERBOSE} && echo "PASS: ${TEST}"
fi

${SD}/stopmts.sh
fi


# ----------------------------------------
rm -f ${ACCMAP} ${ALIMAP} ${MTMAP}

# ----------------------------------------
# end
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
