#!/bin/sh
# $Id: t-relay-1.sh,v 1.9 2005/10/21 18:02:20 ca Exp $
# Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test relaying for local addresses
# run smtpcnf.sh with different parameters
# ----------------------------------------
#
test -s stop && exit 1
#

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# cd to working directory for alias file!
cd ../qmgr || exit 1

#
if test -z "${NS}"
then
  echo "$0: no nameserver found"
  exit 1
fi

${CAT} > ${SMXCNF} <<EOF
qmgr { Log_Level = 12; wait_for_server=4; wait_for_client=4; }
smar { Log_Level = 12; nameserver = ${NS}; }
smtpc { Log_Level = 12; remote_port=${SNKPORT}; wait_for_server=4; }

smtps {
Log_Level = 12;
flags = {access, };
daemon_address = localhost:${SRVPORT};
relay_from = "No.host.";
relay_to = "No.host.";
wait_for_server=4;
}
EOF

${CAT} > ${MT} <<EOF
relay.ok	[127.0.0.1]
domain.relay	[127.0.0.1]
x.y	[127.0.0.1]
a.b	[127.0.0.1]
local.dom	lmtp:
EOF

# create access map
${CAT} > ${ACC} <<EOF
EOF
# create map
rm -f ${ACCMAP}
${MM} -t'	' -F ${ACCMAP} < ${ACC}

# create aliases map
${CAT} > ${ALI} <<EOF
luser1:	local:
EOF
# create map
rm -f ${ALIMAP}
${MM} < ${ALI}

# run some test programs

# ----------------------------------------
# relaying allowed because recipient is local and option is turned on
TEST=1
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false
if ${SHELL} ${SD}/smtpcnf.sh -3 lmtpsock -Ssender${TEST}@a.b -Rluser1@local.dom -E 0 -X 0 -A 1
then
  :
else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
else
   ${VERBOSE} && echo "PASS: ${TEST}"
fi
fi

${CAT} > ${SMXCNF} <<EOF
qmgr { Log_Level = 12; wait_for_server=4; wait_for_client=4; }
smar { Log_Level = 12; nameserver = ${NS}; }
smtpc { Log_Level = 12; remote_port=${SNKPORT}; wait_for_server=4; }

smtps {
Log_Level = 12;
flags = {access, lmtp_does_not_imply_relaying};
daemon_address = localhost:${SRVPORT};
relay_from = "No.host.";
relay_to = "No.host.";
wait_for_server=4;
}
EOF


# ----------------------------------------
# relaying denied even though recipient is local because option is turned off
TEST=2
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false
if ${SHELL} ${SD}/smtpcnf.sh -3 lmtpsock -Ssender${TEST}@a.b -Rluser1@local.dom -E 0 -X 0 -A 0
then
  :
else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
else
   ${VERBOSE} && echo "PASS: ${TEST}"
fi
fi


# ------
rm -f ${MTMAP}

# ----------------------------------------
# end
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
