#!/bin/sh
# $Id: t-rsr-problem-0.sh,v 1.9 2005/10/21 18:02:20 ca Exp $
# Copyright (c) 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test resource problems in QMGR when getting updates about delivery attempts
# uses smtp1.sh
# ----------------------------------------
#
test -s stop && exit 1
#

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh

SCRIPTS=`cd ${SD} && pwd`

OUT="t-rsr-problem-0.out"

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# cd to right directory (where the programs will be executed).
cd ../qmgr || exit 1

if ./qmgr -VVV 2>/dev/null | ${GREP} QMGR_TEST >/dev/null
then
  :
else
  echo "$0: qmgr not compiled with QMGR_TEST; test SKIPPED"
  exit 0
fi

rm -f ${MTMAP}

TEST=1
# ----------------------------------------
# reject RCPT in sink, trigger resource problem (ENOMEM)

if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
if ${SHELL} ${SD}/smtp1.sh -E 1 -z q -Q '-t 2' -S"s01@b.c" -R"459@y.z"
then
    ERR=false
    # mail must be still in ibdb
    ${IDBR0} > ${OUT} || ERR=true
    ${GREP} 'mail_pa=<s01@b.c>' ${OUT} >/dev/null || ERR=true
    ${GREP} 'rcpt_pa=<459@y.z>' ${OUT} >/dev/null || ERR=true
else
    ERR=true
    echo "$0: test ${TEST} failed"
    test X"${SM_STOPONERROR}" != X && exit 1
fi
if ${GREP} 'sev=ERROR, func=qm_fr_sc_react,' q0.log >/dev/null
then
  :
else
  ERR=true
fi
if ${ERR}
then
    echo "$0: test ${TEST} check failed"
    ERRS=`expr ${ERRS} + 1 `
    test X"${SM_STOPONERROR}" != X && exit 1
else
    ${VERBOSE} && echo "test ${TEST} succeeded"
fi
fi


# ----------------------------------------
# end
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
