#!/bin/sh
# $Id: t-smtpf3.sh,v 1.12 2005/10/21 18:02:20 ca Exp $
# Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test error handling from different components
# run smtp1.sh with different parameters
# ----------------------------------------
#
test -s stop && exit 1
#

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh
I=""
ERRS=0
EDBROK="../qmgr/t-smtpf3-edbr.ok"
SKIP=""

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# cd to right directory (where the programs will be executed).
cd ../qmgr || exit 1
rm -f ${MTMAP}

TEST=1
# ----------------------------------------
# temporary failure from SMTP sink data dot.
# no mail can be delivered because of that.
# carefully time this such that a bounce and a double bounce are generated
# but the double bounce is NOT dropped, i.e., it stays in defedb.

${CAT} > ${EDBROK} <<EOF
got transaction
	mail=<f3s1@b.c>
	rcpts_tot=3
	rcpts_left=1
	rcpts_temp=1
	rcpts_perm=0
	state=451
	aqt_rcpts_ar=0
got recipient
	rcpt=<bounce@y.z>
	aqr_rcpt_idx=2
	aqr_da_idx=0
	aqr_status=451
EOF
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
if ${SHELL} ${SD}/smtp1.sh $@ -1 -s 60 -Q '-P<bounce@y.z> -T 10' -i 14 -Y '-F 451' -O ${EDBROK} -E 5 -A 1 -X 0 -S"f3s1@b.c" -R"f3ok3@y.z"
then
    ${VERBOSE} && echo "test ${TEST} succeeded"
else
    echo "$0: test ${TEST} failed"
    ERRS=`expr ${ERRS} + 1 `
    test X"${SM_STOPONERROR}" != X && exit 1
fi
fi


# ----------------------------------------
# end
if test "${ERRS}" = "0"
then
  rm -f ${EDBROK}
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
