#!/bin/sh
# $Id: t-toomanyhops.sh,v 1.5 2005/10/21 18:02:20 ca Exp $
# Copyright (c) 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test "too many hops" handling.
# uses smtp1.sh
# ----------------------------------------
#
test -s stop && exit 1
#

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh

I=""
ERRS=0
OK="t-toomanyhops.ok"
OUT="t-toomanyhops.out"
DATA="t-toomanyhops.in"

if test X"`uname`" != "XOSF1"
then
while getopts L:M:S:s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    S) STEP="${OPTARG}";;
    V) VERBOSE=true;;
    ?)
       echo "$0: unknown option ${FLAG}"
       echo "$0: options:"
       echo "-s n       skip test number n"
       exit 1
       ;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# cd to working directory for alias file!
cd ../qmgr || exit 1

# create aliases
${CAT} > ${ALI} <<EOF
abuse:	local:
postmaster:	local:
user:	local:
sender: local:
EOF
# create map
rm -f ${ALIMAP}
${MM} < ${ALI}
rm -f ${MTMAP}

HOPS=21
MAX_HOPS=22
ALLOWED_HOPS=21
TEST=0

while test ${HOPS} -le ${MAX_HOPS}
do

rm -f ${DATA}
${CAT} > ${DATA} <<EOF
From: sender@local.dom
To: user@local.dom
Subject: test data
EOF
i=1
while test ${i} -le ${HOPS}
do
${CAT} >> ${DATA} <<EOF
Received: from local.host (local.host [127.0.0.1])
	by host.local.dom (sendmail X test) with ESMTP
	id S000000000006AA21${i}; Fri,  8 Jul 2005 21:24:33 -0700
EOF
i=`expr ${i} + 1 `
done
${CAT} >> ${DATA} <<EOF

hops: ${i}
EOF

# ----------------------------------------
TEST=`expr ${TEST} + 1 `
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false
if test ${HOPS} -le ${ALLOWED_HOPS}
then
  MAILS=1
else
  MAILS=0
fi
if ${SHELL} ${SD}/smtp1.sh -Z smtpc2 -c "-D ${DATA}" -3 lmtpsock -Ssender@local.dom -Ruser@local.host -E ${MAILS} -X ${MAILS} -A ${MAILS}
then
  :
else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
   break
elif ${VERBOSE}
then
   echo "$0: test ${TEST} OK"
fi
fi

HOPS=`expr ${HOPS} + 1 `
done


# ----------------------------------------
# end
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
