/*
 * This code is derived from inetd.c as distributed with various BSD versions.
 */

/*
 * Copyright (c) 1983, 1991, 1993, 1994
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * Copyright (c) 2003 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: conncache.h,v 1.3 2003/05/27 20:26:04 ca Exp $
 */

#ifndef SM_CONNCACHE_H
#define SM_CONNCACHE_H 1

#include "sm/generic.h"
#include "sm/types.h"
#include "sm/net.h"

/* time granularity: 10s (that's one "tick") */
#define CHTGRAN		10
#define CHTSIZE		6

/* Number of connections for a certain "tick" */
struct cc_time_S
{
	ulong	cct_ticks;
	int	cct_count;
};
typedef struct cc_time_S	cc_time_T, *cc_time_P;

/* use one "global" prefix, e.g., "DA", or "SS"? */

#define CC_ENTRY_S(prefix)	\
struct prefix##cc_entry_S	\
{	\
	in_addr_T	prefix##cc_entry_addr;	/* addr of connection XXX IPv6 */	\
	time_t		prefix##cc_entry_ltime;	/* last touch */	\
	/* 6 buckets for ticks: 60s */	\
	cc_time_T	prefix##cc_entry_times[CHTSIZE];	\
};	\
typedef struct prefix##cc_entry_S prefix##cc_entry_T, *prefix##cc_entry_P;

#define CC_CTX_S(prefix)	\
struct prefix##cc_ctx_S	\
{	\
	uint		 prefix##ccc_max_steps;	/* max. entries to search */ \
	uint		 prefix##ccc_size;	/* size of array */	\
	cc_entry_P	 prefix##ccc_entries;	/* array of cc entries */	\
};	\
typedef struct prefix##cc_ctx_S prefix##cc_ctx_T, *prefix##cc_ctx_P;

#if 0
sm_ret_T	 sm_conncache_new(uint _size, uint _steps, size_t entry_size, cc_ctx_P *_pcc_ctx);
sm_ret_T	 sm_conncache_free(cc_ctx_P _cc_ctx);
sm_ret_T	 sm_conncache(cc_ctx_P _cc_ctx, in_addr_T _addr, time_t _curt, uint *_pidx, char **_base);
#endif /* 0 */

#define CC_CTX_FREE(prefix)	\
sm_ret_T	\
prefix##conncache_free(prefix##cc_ctx_P cc_ctx)	\
{	\
	if (cc_ctx == NULL)	\
		return SM_SUCCESS;	\
	SM_FREE(cc_ctx->ccc_entries);	\
	sm_free_size(cc_ctx, sizeof(*cc_ctx));	\
	return SM_SUCCESS;	\
}

#define CC_CTX_NEW(prefix)	\
sm_ret_T	\
sm_conncache_new(uint size, uint steps, prefix##cc_ctx_P *pcc_ctx)	\
{	\
	prefix##cc_ctx_P cc_ctx;	\
	size_t s;	\
	\
	SM_REQUIRE(pcc_ctx != NULL);	\
	SM_REQUIRE(size > 4);	\
	/* require size to be a power of 2? */	\
	\
	SM_REQUIRE(steps > 2);	\
	\
	cc_ctx = (prefix##cc_ctx_P) sm_zalloc(sizeof(*cc_ctx));	\
	if (cc_ctx == NULL)	\
		return sm_err_temp(ENOMEM);	\
	\
	if (entry_size == 0)	\
		entry_size = sizeof(*(cc_ctx->ccc_entries));	\
	s = size * entry_size;	\
	cc_ctx->ccc_entries = (cc_entry_P) sm_zalloc(s);	\
	if (cc_ctx->ccc_entries == NULL)	\
		goto error;	\
	\
	cc_ctx->ccc_size = size;	\
	cc_ctx->ccc_max_steps = steps;	\
	*pcc_ctx = cc_ctx;	\
	return SM_SUCCESS;	\
	\
  error:	\
	SM_FREE(cc_ctx->ccc_entries);	\
	sm_free_size(cc_ctx, sizeof(*cc_ctx));	\
	return sm_err_temp(ENOMEM);	\
}

#define CC_CONCACHE(prefix)	\
sm_ret_T	\
sm_conncache(prefix##cc_ctx_P cc_ctx, in_addr_T addr, time_t curt)	\
{	\
	int i, cnt;	\
	uint hv, ticks, idx;	\
	unsigned char *p;	\
	prefix##cc_entry_P cce_best;	\
	prefix##cc_time_P ct;	\
	int c, d;	\
	\
	cnt = 0;	\
	hv = 0xABC3D20F;	\
	ticks = curt / CHTGRAN;	\
	cce_best = NULL;	\
	\
	/* compute hash value */	\
	for (i = 0, p = (unsigned char *) &addr; i < sizeof(addr); ++i, ++p)	\
	{	\
		d = *p;	\
		c = d;	\
		c ^= c<<6;	\
		hv += (c<<11) ^ (c>>1);	\
		hv ^= (d<<14) + (d<<7) + (d<<4) + d;	\
	}	\
	\
	/*	\
	**  Find matching or free bucket.	\
	**  Remember the least recently used bucket in case no matching	\
	**  or free bucket is found.	\
	*/	\
	\
	idx = 0;	\
	for (i = 0; i < cc_ctx->ccc_max_steps; ++i)	\
	{	\
		cc_entry_P cce;	\
	\
		/* Use & if size == 2^n */	\
		idx = (hv + i) % cc_ctx->ccc_size;	\
		cce = CCC_ENTRY_ACC(cc_ctx, idx);	\
	\
		/* matching or free entry? */	\
		if (addr.s_addr == cce->cce_addr.s_addr ||	\
		    cce->cce_addr.s_addr == 0)	\
		{	\
			cce_best = cce;	\
			break;	\
		}	\
		if (cce_best == NULL || cce->cce_ltime == 0 ||	\
		    cce->cce_ltime < cce_best->cce_ltime)	\
			cce_best = cce;	\
	}	\
	\
	/*	\
	**  If it's not a match, then replace the data.	\
	**  Note: this purges the history of a colliding entry,	\
	**  which may cause "overruns", i.e., if two entries are	\
	**  "cancelling" each other out, then they may exceed	\
	**  the limits that are set. This might be mitigated a bit	\
	**  by the above "best of 5" function however.	\
	**	\
	**  Alternative approach: just use the old data, which may	\
	**  cause false positives however.	\
	*/	\
	\
	if (addr.s_addr != cce_best->cce_addr.s_addr)	\
	{	\
		sm_memzero(cce_best, sizeof(cce_best));	\
		cce_best->cce_addr = addr;	\
	}	\
	cce_best->cce_ltime = curt;	\

/*
**  this is the end...
**  The application can now add its own code.
*/


#define CC_CONCACHE_END(prefix)	\
	ct = &cce_best->cce_times[ticks % CHTSIZE];	\
	if (ct->cct_ticks != ticks)	\
	{	\
		ct->cct_ticks = ticks;	\
		ct->cct_count = 0;	\
	}	\
	++ct->cct_count;	\
	for (i = 0; i < CHTSIZE; ++i)	\
	{	\
		ct = &cce_best->cce_times[i];	\
		if (ct->cct_ticks <= ticks &&	\
		    ct->cct_ticks >= ticks - CHTSIZE)	\
			cnt += ct->cct_count;	\
	}	\
	\
	return (cnt * 60) / (CHTSIZE * CHTGRAN);	\
}
