/*
 * Copyright (c) 2001 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: fdset.h,v 1.3 2005/06/16 00:09:34 ca Exp $
 */

#ifndef SM_FDSET_H
#define SM_FDSET_H 1

#if WIN32
# include <io.h>
# define SM_FD_SET(fd, pfdset)		_FD_SET(fd, pfdset)
# define SM_FD_ISSET(fd, pfdset)	_FD_ISSET(fd, pfdset)

/*
**  Windows has an array of sockets (of size FD_SETSIZE) instead of
**  a bitmap.  Therefore, the test used in UNIX doesn't work.
**  Instead, you could test if the number of sockets being added
**  FD_SET() but in our case, it's only one so why bother.
*/

# define SM_FD_SETSIZE	0
#else /* WIN32 */
# define SM_FD_SET(fd, pfdset)		FD_SET(fd, pfdset)
# define SM_FD_ISSET(fd, pfdset)	FD_ISSET(fd, pfdset)
# define SM_FD_SETSIZE	FD_SETSIZE
#endif /* WIN32 */

#endif /* SM_FDSET_H */
