/*
 * Copyright (c) 2002, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: signal.h,v 1.6 2005/06/17 00:35:26 ca Exp $
 */

#ifndef SM_SIGNAL_H
#define SM_SIGNAL_H 1

#if WIN32
# pragma once
#endif /* WIN32 */
#include <signal.h>

/*
**  Character to be written to pipe when signal handler catches the
**  corresponding signal.
*/

#define SM_SIG_HUP	'H'
#define SM_SIG_INT	'I'
/* #define SM_SIG_QUIT	'Q'	not yet used */
/* #define SM_SIG_ILL	'L'	not yet used */
/* #define SM_SIG_TRAP	'T'	not yet used */
#define SM_SIG_ALRM	'A'
#define SM_SIG_CHLD	'C'
#define SM_SIG_TERM	'T'
#define SM_SIG_USR1	'1'
#define SM_SIG_USR2	'2'
#define SM_SIG_PIPE	'P'

#define SM_SIG_UNKNOWN	'U'	/* unknown signal (not explicitly handled) */

/* pseudo signal: an error occurred in signal handler */
#define SM_SIG_ERR	'E'

typedef void (*sm_sighandler_F)(int _signo);
#if 0
typedef void (*sm_sigaction_F)(int _signo, siginfo_t *_sip, void *_ctx);
#endif

typedef void (*sm_sigwrfail_F)(int _errno, void *_ctx);

/* bit mask to create set of signal that should be handled */
#define SM_HDL_SIG_HUP	0x0001
#define SM_HDL_SIG_INT	0x0002
#define SM_HDL_SIG_ALRM	0x0004
#define SM_HDL_SIG_CHLD	0x0008
#define SM_HDL_SIG_TERM	0x0010
#define SM_HDL_SIG_USR1	0x0020
#define SM_HDL_SIG_USR2	0x0040
#define SM_HDL_SIG_PIPE	0x0080
/* #define SM_HDL_SIG_QUIT	0x0100	not yet used */
/* #define SM_HDL_SIG_ILL	0x0200	not yet used */
/* #define SM_HDL_SIG_TRAP	0x0400	not yet used */


#if SM_USE_STATETHREADS
sm_ret_T st_install_sighandlers(uint _signalset, sm_sigwrfail_F _sigwrfail, void *_ctx);
#endif

/* read/write part of signal pipe */
#define SM_RD_SIG_PIPE	0
#define SM_WR_SIG_PIPE	1

#endif /* SM_SIGNAL_H */
