/*
 * Copyright (c) 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: sm_extracthdr.h,v 1.2 2005/09/01 17:14:03 ca Exp $
 */

#ifndef SM_EXTRACTHDR_H
#define SM_EXTRACTHDR_H 1

#include "sm/generic.h"
#include "sm/types.h"
#include "sm/str.h"

typedef struct sm_xhdr_ctx_S	sm_xhdr_ctx_T, *sm_xhdr_ctx_P;
struct sm_xhdr_ctx_S
{
	int		sm_xhdr_state;
	uint		sm_xhdr_crlf;
	uint		sm_xhdr_flags;
	size_t		sm_xhdr_chunk_off;	/* offset in chunk */
	sm_str_P	sm_xhdr_name;
	sm_str_P	sm_xhdr_value;
};

#define SM_XHDR_EOHDR	0 /* end of header reached */
#define SM_XHDR_CONT	1 /* need more input */
#define SM_XHDR_GOT1	2 /* got one header */
#define SM_XHDR_GOTA	3 /* got one header, but there's more in this chunk */
#define SM_XHDR_GOTL	4 /* got one header, end of header reached */

#define SM_XHDR_FL_SKIP_FIRST_BLANK	1
#define SM_XHDR_FL_SKIP_LEADING_BLANKS	2

sm_ret_T sm_xhdr_init(uint _flags, sm_xhdr_ctx_P *_psm_xhdr_ctx);
sm_ret_T sm_xhdr_end(sm_xhdr_ctx_P _sm_xhdr_ctx);
sm_ret_T sm_xhdr(const uchar *_chunk, size_t _len, sm_xhdr_ctx_P _sm_xhdr_ctx);

#endif /* SM_EXTRACTHDR_H */
