/*
 * Copyright (c) 2002, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: socket.h,v 1.6 2005/08/25 20:07:00 ca Exp $
 */

#ifndef SM_SOCKET_H
#define SM_SOCKET_H 1

#if HAVE_SYS_SOCKET_H
# include <sys/socket.h>
#endif

#include "sm/error.h"
#include "sm/sockcnf.h"

sm_ret_T sock_connect(sockspec_P _sock, int *_pfd);
sm_ret_T sock_listen(sockspec_P _sock, int _backlog, int *_pfd);
sm_ret_T socket_accept(int _listenfd, sm_sockaddr_P _addr, sockaddr_len_T *_addrlen, int *_pfd);

sm_ret_T parsesockstr(const char *_sockstr, sockspec_P _sockspec);

#endif /* SM_SOCKET_H */
