/*
 * Copyright (c) 2003, 2004 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: statfs.h,v 1.7 2005/06/16 00:09:35 ca Exp $
 */

#ifndef SM_STATFS_H
#define SM_STATFS_H 1

#include "sm/generic.h"
#include "sm/types.h"
#include "sm/error.h"

/* statfs types */
#define SFS_NONE	0	/* no statfs implementation */
#define SFS_USTAT	1	/* use ustat */
#define SFS_4ARGS	2	/* use four-argument statfs call */
#define SFS_VFS		3	/* use <sys/vfs.h> implementation */
#define SFS_MOUNT	4	/* use <sys/mount.h> implementation */
#define SFS_STATFS	5	/* use <sys/statfs.h> implementation */
#define SFS_STATVFS	6	/* use <sys/statvfs.h> implementation */

#if HAVE_STATFS && HAVE_STATFS_H
# define SFS_TYPE	SFS_STATFS
#elif HAVE_STATVFS && HAVE_STATVFS
# define SFS_TYPE	SFS_STATVFS
#elif HAVE_STATFS_4ARGS
# define SFS_TYPE	SFS_4ARGS
#elif HAVE_USTAT && HAVE_USTAT_H
# define SFS_TYPE	SFS_USTAT
#elif HAVE_SYS_VFS_H
# define SFS_TYPE	SFS_USTAT
#endif

#if SFS_TYPE == SFS_USTAT
# include <ustat.h>
#elif SFS_TYPE == SFS_STATFS
# include <sys/statfs.h>
#elif SFS_TYPE == SFS_STATVFS
# include <sys/statvfs.h>
#elif HAVE_SYS_MOUNT_H
# include <sys/param.h>
# include <sys/mount.h>
#elif SFS_TYPE == SFS_VFS
# include <sys/vfs.h>
#else
 ERROR no stat type defined
#endif

/*
XXX Check whether "blocks free" in statfs is unsigned?
*/

sm_ret_T freediskspace(const char *_dir, ulong *_bsize, ulong *_ppkbfree);

#endif /* SM_STATFS_H */
