/*
 * Copyright (c) 2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: dnstype2txt.c,v 1.1 2005/09/02 06:22:39 ca Exp $")
#include "sm/ctype.h"
#include "sm/dns.h"

/*
**  DNSTYPE2TXT -- return type of query in textual format
**
**	Parameters:
**		type -- DNS type
**
**	Returns:
**		textual format of DNS type
*/

char *
dnstype2txt(dns_type_T type)
{
	switch (type)
	{
	  case T_MX:
		return "MX";
	  case T_TXT:
		return "TXT";
	  case T_A:
		return "A";
	  case T_AAAA:
		return "AAAA";
	  case T_PTR:
		return "PTR";
	  case T_CNAME:
		return "CNAME";
	  default:
		return "Unknown";
	}
	return "Oops";
}
