/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: log.h,v 1.4 2005/06/16 00:39:04 ca Exp $
 */

#ifndef LIBDNS_LOG_H
#define LIBDNS_LOG_H 1

#include "sm/generic.h"
#include "sm/log.h"

#if LIBDNS_LOG_DEFINES
sm_logcategory_T libdns_lcats[] =
{
	{ "init",	0 },
	{ "config",	0 },
	{ "resolver",	0 },
	{ "comm",	0 },
	{ NULL,		0 }
};

sm_logmodule_T libdns_lmods[] =
{
	{ "libdns/config",	0 },
	{ "libdns/resolver",	0 },
	{ "libdns/comm",	0 },
	{ NULL,			0 }
};

#else /* LIBDNS_LOG_DEFINES */

/* should these be global or per libdns context? */
extern sm_logcategory_T libdns_lcats[];
extern sm_logmodule_T libdns_lmods[];

#endif /* LIBDNS_LOG_DEFINES */

#define LIBDNS_LCAT_INIT	(&libdns_lcats[0])
#define LIBDNS_LCAT_CONFIG	(&libdns_lcats[1])
#define LIBDNS_LCAT_RESOLVER	(&libdns_lcats[2])
#define LIBDNS_LCAT_COMM	(&libdns_lcats[3])

/* Backwards compatibility. */
#define LIBDNS_LCAT_GENERAL	SM_LOGCATEGORY_GENERAL

#define LIBDNS_LMOD_CONFIG	(&libdns_lmods[0])
#define LIBDNS_LMOD_RESOLVER	(&libdns_lmods[1])
#define LIBDNS_LMOD_COMM	(&libdns_lmods[2])

#if 0
void	 libdns_log_init(sm_log_ctx_P _lctx);
void	 libdns_log_setcontext(sm_log_ctx_P _lctx);
#endif

#endif /* LIBDNS_LOG_H */
