/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: edbstat.c,v 1.9 2005/07/25 23:35:30 ca Exp $")
#include "sm/error.h"
#include "sm/memops.h"
#include "sm/assert.h"
#include "sm/str.h"
#include "sm/io.h"
#include "sm/edb.h"
#include "edb-int.h"
#include "sm/pthread.h"

/*
**  EDB_STATUS -- print EBD status to file
**
**	Parameters:
**		edb_ctx - EDB context
**		fp - output file
**
**	Returns:
**		usual sm_error code
**
**	Locking:
**		tries to lock edb_ctx during operation
*/

sm_ret_T
edb_status(edb_ctx_P edb_ctx, sm_file_T *fp)
{
	sm_ret_T ret;
	int r;
	DB_BTREE_STAT *bst;
	DB_LOG_STAT *logstat;
	DB_ENV *dbenv;

	SM_IS_EDB_CTX(edb_ctx);
	ret = SM_SUCCESS;
	r = pthread_mutex_trylock(&(edb_ctx->edb_mutex));
	if (r == EBUSY)
		return sm_error_info(SM_EM_EDB, SM_NOTDONE);	/* really? */
	if (r != 0)
		return sm_error_perm(SM_EM_EDB, r);
	dbenv = edb_ctx->edb_bdbenv;

	r = edb_ctx->edb_bdb->stat(edb_ctx->edb_bdb,
				BDB43STATTXN	/* needed for BDB 4.3 */
				&bst, DB_FAST_STAT);
	if (r == 0)
	{
		sm_io_fprintf(fp, "BDB btree stats:\n"
			"bt_nkeys=%d\n"
			"bt_ndata=%d\n"
			"bt_pagesize=%d\n"
			"bt_minkey=%d\n"
			, bst->bt_nkeys
			, bst->bt_ndata
			, bst->bt_pagesize
			, bst->bt_minkey
			);
	}

	r = dbenv->log_stat(dbenv, &logstat, 0);
	if (r == 0)
	{
		sm_io_fprintf(fp, "BDB log stats:\n"
			"Log version number=%lu\n"
			"Log record cache size=%lu\n"
			"Log file mode=%#o\n"
			"Current log file size=%lu\n"
			"Log bytes written=%lu.%06lu\n"
			"Log bytes written since last checkpoint=%lu.%06lu\n"
			"Total log file writes=%lu\n"
			"Total log file write due to overflow=%lu\n"
			"Total log file flushes=%lu\n"
			"Current log file number=%lu\n"
			"Current log file offset=%lu\n"
			"On-disk log file number=%lu\n"
			"On-disk log file offset=%lu\n"
			"Max commits in a log flush=%lu\n"
			"Min commits in a log flush=%lu\n"
			"Log region size=%lu\n"
			"The number of region locks granted after waiting=%lu\n"
			"The number of region locks granted without waiting=%lu\n"
			, (ulong)logstat->st_version
			, (ulong)logstat->st_lg_bsize
			, logstat->st_mode
			, (ulong)logstat->st_lg_size
			, (ulong)logstat->st_w_mbytes
			, (ulong)logstat->st_w_bytes
			, (ulong)logstat->st_wc_mbytes, (ulong)logstat->st_wc_bytes
			, (ulong)logstat->st_wcount
			, (ulong)logstat->st_wcount_fill
			, (ulong)logstat->st_scount
			, (ulong)logstat->st_cur_file
			, (ulong)logstat->st_cur_offset
			, (ulong)logstat->st_disk_file
			, (ulong)logstat->st_disk_offset
			, (ulong)logstat->st_maxcommitperflush
			, (ulong)logstat->st_mincommitperflush
			, (ulong)logstat->st_regsize
			, (ulong)logstat->st_region_wait
			, (ulong)logstat->st_region_nowait
			);

		free(logstat);
	}


	r = pthread_mutex_unlock(&(edb_ctx->edb_mutex));
	SM_ASSERT(r == 0);
	if (r != 0 && sm_is_success(ret))
		ret = sm_error_perm(SM_EM_EDB, r);
	return ret;
}

