/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: compoptions.c,v 1.3 2005/09/23 18:05:07 ca Exp $")
#include "sm/error.h"
#include "sm/assert.h"
#include "sm/evthr.h"
#include "sm/str.h"

/*
**  EVTHR_COMPOPTIONS -- return compile time options
**
**	Parameters:
**		evthr_ctx -- evthr context (currently unused)
**		str -- string to fill in (output)
**
**	Returns:
**		usual sm_error code
*/

sm_ret_T
evthr_comptoptions(sm_evthr_ctx_P evthr_ctx, sm_str_P str)
{
	sm_ret_T ret;

#if 0
	SM_IS_EVTHR_CTX(evthr_ctx);
#endif
	SM_REQUIRE(str != NULL);
	ret = sm_str_scat(str,
#ifndef EVTHR_DEBUG
		"EVTHR_DEBUG, "
#ifndef EVTHR_1
#define EVTHR_1 1
#endif
#endif
#ifndef EVTHR_PARANOIA
		"EVTHR_PARANOIA, "
#ifndef EVTHR_1
#define EVTHR_1 1
#endif
#endif
#ifndef SM_LOCK_TASK
		"SM_LOCK_TASK, "
#ifndef EVTHR_1
#define EVTHR_1 1
#endif
#endif
#ifndef EVTHR_1
		""
#endif
		);
	return ret;
}
