#!/bin/sh
# $Id: t-evthr-sig.sh,v 1.5 2004/12/29 23:47:33 ca Exp $
# Copyright (c) 2003, 2004 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
#
test -s stop && exit 1
R=0
# 
# program used in these tests
EVS=t-evthr-3

# ----------------
# how to determine whether pthreads are POSIX compliant?
# currently we don't have any Linux versions with real pthreads.
if test X"`uname`" = "XLinux"
then
  exit 0
fi

# wait for two signals
./${EVS} -l 1 &
P=$!
# wait a bit
sleep 3
# send USR1
kill -USR1 ${P}
sleep 3
# send USR1; this will terminate the process
kill -USR1 ${P}
# wait a bit
sleep 3
# this should fail
kill ${P} 2>/dev/null && R=1

# ----------------
# thanks kids for not following the POSIX standard...
if test X"`uname`" = "XLinux"
then
  killall ${EVS}
fi

exit ${R}
