/*
 * Copyright (c) 2002, 2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: fgetn.c,v 1.8 2005/06/02 19:00:36 ca Exp $")
#include "sm/error.h"
#include "sm/assert.h"
#include "sm/io.h"
#include "sm/memops.h"

/*
**  SM_IO_FGETN -- read a string from the buffer of the file pointer
**
**	Parameters:
**		fp -- the file pointer for the buffer to be written to
**		s -- string into which data should be placed
**		n -- length of string
**
**	Returns:
**		usual sm_error code
*/

sm_ret_T
sm_io_fgetn(sm_file_T *fp, uchar *s, size_t l)
{
	int la;
	ssize_t rd;
	sm_ret_T ret;

	SM_REQUIRE_ISA(fp, SM_FILE_MAGIC);
	SM_REQUIRE(s != NULL);
	SM_REQUIRE(l < INT_MAX);

	la = SM_ALIGN4(l);
	if (f_r(*fp) >= la)
	{
		(void) sm_memcpy(s, f_p(*fp), l);
		f_r(*fp) -= la;
		f_p(*fp) += la;
		return SM_SUCCESS;
	}

	/* not enough data in buffer: use read() */
	la -= l;	/* how much alignment do we need? */
	do
	{
		ret = sm_io_read(fp, s, l, &rd);
		if (sm_is_err(ret))
			return ret;
		l -= rd;
		s += rd;
	} while (l != 0);

	/* read some more bytes for alignment */
	while (la-- != 0)
	{
		ret = sm_getc(fp);
		if (sm_is_err(ret))	/* can be only EOF right now? */
			return ret;
	}
	return SM_SUCCESS;
}
