/*
 * Copyright (c) 2003, 2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: fgetncstr.c,v 1.9 2005/06/02 19:00:36 ca Exp $")
#include "sm/error.h"
#include "sm/assert.h"
#include "sm/cstr.h"
#include "sm/io.h"
#include "sm/memops.h"

#if !SM_NO_CSTR
/*
**  SM_IO_FGETNCSTR -- read a constant string from the buffer of the file
**
**	Parameters:
**		fp -- the file pointer for the buffer to be written to
**		pcstr -- constant string to be created (output)
**		l -- length of string
**
**	Returns:
**		usual sm_error code
*/

sm_ret_T
sm_io_fgetncstr(sm_file_T *fp, sm_cstr_P *pcstr, uint l)
{
	int la;
	ssize_t rd;
	sm_ret_T ret;
	sm_cstr_P cstr;
	uchar *buf;

	SM_REQUIRE_ISA(fp, SM_FILE_MAGIC);
	SM_REQUIRE(pcstr != NULL);
	SM_REQUIRE(l < INT_MAX);

	buf = (uchar *) sm_malloc(l);
	if (buf == NULL)
		return sm_error_temp(SM_EM_RECCOM, ENOMEM);
	cstr = sm_cstr_crt(buf, l);
	if (cstr == NULL)
	{
		sm_free_size(buf, l);
		return sm_error_temp(SM_EM_RECCOM, ENOMEM);
	}
	*pcstr = cstr;
	la = SM_ALIGN4(l);
	SM_ASSERT(la > 0);
	if (f_r(*fp) >= la)
	{
		(void) sm_memcpy(buf, f_p(*fp), l);
		f_r(*fp) -= la;
		f_p(*fp) += la;
		return SM_SUCCESS;
	}

	/* not enough data in buffer: use read() */
	la -= l;	/* how much alignment do we need? */
	do
	{
		ret = sm_io_read(fp, buf, l, &rd);
		if (sm_is_err(ret))
			return ret;
		l -= rd;
		buf += rd;
	} while (l != 0);

	/* read some more bytes for alignment */
	while (la-- != 0)
	{
		ret = sm_getc(fp);
		if (sm_is_err(ret))	/* can be only EOF right now? */
			return ret;
	}
	return SM_SUCCESS;
}
#endif /* !SM_NO_CSTR */
