/*
 * Copyright (c) 2000-2002, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: strclr.c,v 1.10 2005/02/11 20:55:41 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/memops.h"
#include "sm/rpool.h"
#include "sm/strrcb.h"
#include "sm/str-int.h"
#include "sm/str2rcb.h"
#if SM_STR_CHECK

/*
**  SM_STR_CLR -- Clear out data in str prepare for re-use.
**
**	This is useful in cases where you don't want to keep
**	allocating new bufs and immediately throwing them away.
**
**	Parameters:
**		str -- sm_str_P object to clear.
**
**	Returns:
**		nothing.
*/

void
sm_str_clr(sm_str_P str)
{
	SM_IS_BUF(str);
	SM_REQUIRE(str->sm_str_base != NULL);

	str->sm_str_len = 0;
#if SM_STR_READ
	str->sm_rcb_rw = 0;
#endif

	/* just for the fun of it... */
	sm_memzero(str->sm_str_base, str->sm_str_size);
}
#endif /* SM_STR_CHECK */
