/*
 * Copyright (c) 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: t-pm-0.c,v 1.6 2005/09/15 23:03:48 ca Exp $")
#include "sm/error.h"
#include "sm/assert.h"
#include "sm/types.h"
#include "sm/sysexits.h"
#include "sm/fcntl.h"
#include "sm/io.h"
#include "sm/ctype.h"
#include "sm/reccom.h"
#include "sm/mta.h"
#define PMILTER_DEBUG_DEFINE 1
#include "pmilter.h"
#include "sm/pmfdef.h"
#include "sm/pmfapi.h"
#include "sm/pmilter.h"
#include "util.h"
#include "sm/test.h"

#if SM_USE_PMILTER
/*
static pmilter_T
pmilter =
{
	"t-pm-0",
	LPMILTER_VERSION,
	SM_SCAP_PM_ALL,
	0,
	0,
	0,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL
};
*/

/*
**  USAGE -- Print usage message to smioerr
**
**	Parameters:
**		prg -- program name
**
**	Returns:
**		exits
*/

static void
usage(const char *prg)
{
	sm_io_fprintf(smioerr, "usage: %s [options]\n"
#if PMILTER_DEBUG
		"-d n             set debug level\n"
#endif
		, prg
		);
	exit(EX_USAGE);
}


/*
**  MAIN -- PMILTER test server
**
**	Parameters:
**		argc -- number of arguments
**		argv -- vector of arguments
**
**	Returns:
**		exit code
*/

int
main(int argc, char *argv[])
{
	sm_ret_T ret;
	int c;
	uint32_t major, minor, patchlevel;
	pmg_ctx_P pmg_ctx;
	char *prg;

	prg = argv[0];
	pmg_ctx = NULL;
	if (getuid() == 0 || geteuid() == 0)
	{
		sm_io_fprintf(smioerr,
			"%s: ERROR: do not run this as super-user!\n",
			prg);
		exit(EX_USAGE);
	}

	while ((c = getopt(argc, argv, "d:f:r:")) != -1)
	{
		switch (c)
		{
		  case 'd':
#if PMILTER_DEBUG
			pm_debug = atoi(optarg);
#endif
			break;
		  default:
			usage(prg);
			break;
		}
	}

	ret = sm_pmfi_init(&pmg_ctx);
	if (sm_is_err(ret))
	{
		sm_io_fprintf(smioerr, "sev=ERROR, sm_pmfi_init=%x\n", ret);
		goto error;
	}

	sm_test_begin(argc, argv, "test pm 0");

	argc -= optind;
	argv += optind;

	ret = sm_pmfi_version(pmg_ctx, &major, &minor, &patchlevel);
	SM_TEST(ret == SM_SUCCESS);
	SM_TEST(major == 1);
	SM_TEST(minor == 0);
	SM_TEST(patchlevel == 0);

	return sm_test_end();

  error:
	/* select an appropriate error here... */
	return sm_error_value(ret);
}
#else /* SM_USE_PMILTER */
int
main(int argc, char *argv[])
{
	return 0;
}
#endif /* SM_USE_PMILTER */
