/*
 * Copyright (c) 2003, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: inout.c,v 1.3 2005/09/04 06:09:59 ca Exp $")

#include "sm/ctype.h"
#include "sm/sysexits.h"

#include <stdio.h>
#include <signal.h>

static int Verbose = 0;

static void
usage(const char *prg)
{
	fprintf(stderr,
		"usage: %s [options]\n"
		"copy stdin to stdout char by char\n"
		"replace non-printable char with 'X', stop at 'z'/'Z'\n"
		"options:\n"
		"-V        increase verbosity\n"
		, prg);
	exit(EX_USAGE);
}

int
main(int argc, char *argv[])
{
	int i;

	while ((i = getopt(argc, argv, "hV")) != -1)
	{
		switch (i)
		{
		  case 'V':
			++Verbose;
			break;
		  default:
			usage(argv[0]);
			break;
		}
	}
	argc -= optind;
	argv += optind;
	(void) signal(SIGPIPE, SIG_IGN);
	if (Verbose)
		fprintf(stderr, "in=%p, out=%p, err=%p\n",
			stdin, stdout, stderr);
	while ((i = getchar()) != EOF && i != 'z' && i != 'Z')
	{
		if (ISPRINT(i))
			putchar((char)i);
		else
			putchar('X');
		fflush(stdout);
	}
	fflush(stdout);
	return 0;
}
