#!/bin/sh
# $Id: t-mcp-1.sh,v 1.14 2005/07/21 22:07:40 ca Exp $
# Copyright (c) 2003, 2004 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
test -s stop && exit 1

ERRS=0
OUT=mcp.out
RPLY=clt.out
PIDS=pids
CONF=mcp.conf1
SOCK="127.0.0.1"
PORT=1357
VERBOSE=false
SD=`dirname $0`
. ${SD}/../check2/user.sh

if test $# -ge 1
then
  if test "X"$1 = "X-v"
  then
    VERBOSE=true;
  fi
fi

rm -f ${PIDS} ${OUT} ${RPLY}

cat > ${CONF} <<EOF
inout {
	listen_socket { type=inet; port = ${PORT}; }
	start_action = nostartaccept;
	min_processes = 1;
	max_processes = 1;
	user = ${USER};
	path = ./inout;
	arguments = "inout";
}
EOF

./mcp -t -d ${CONF} > ${OUT} 2>&1 &
echo $! >> ${PIDS}

sleep 3

# connect to it?
../misc/t-unixcl -r -p ${PORT} ${SOCK} >${RPLY} 2>/dev/null <<EOF
ABCDEFz
EOF
ST=$?

if test ${ST} != 0
then
  ERRS=`expr ${ERRS} + 1 `
  ${VERBOSE} && echo "t-unixcl: expected=0, got=${ST}"
fi

sleep 1
WC=`wc -c < ${RPLY} | sed -e 's/ //g'`
if test "X"${WC} != X6
then
  ERRS=`expr ${ERRS} + 1 `
  ${VERBOSE} && echo "wc: expected=6, got=${WC}"
fi

for i in `cat ${PIDS}`
do
  kill ${i}
done

exit ${ERRS}
