/*
 * Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: qm_delay_next_try.c,v 1.1 2005/02/28 21:25:51 ca Exp $")
#include "sm/error.h"
#include "sm/assert.h"
#include "sm/qmgr.h"
#include "sm/qmgr-int.h"
#include "qmgr.h"
#include "log.h"

/*
**  QM_DELAY_NEXT_TRY -- Compute delay for next try
**
**	Parameters:
**		qmgr_ctx -- QMGR context
**		aq_rcpt -- AQ recipient
**
**	Returns:
**		seconds to next try
**
**	Called by: q_upd_rcpt_fail(), qm_get_edb_entries()
**
**	Last code review:
**	Last code change:
*/

uint
qm_delay_next_try(qmgr_ctx_P qmgr_ctx, aq_rcpt_P aq_rcpt)
{
	uint delay;
#if !SM_SIMPLER_DELAY
	uint ntries;
#endif

	/*
	**  XXX Need a better formula! XXX
	**  Must depend on connection information etc.
	*/

	SM_IS_QMGR_CTX(qmgr_ctx);
	SM_IS_AQ_RCPT(aq_rcpt);

#if SM_SIMPLER_DELAY
	/*
	**  XXX Using this slight changes the semantics (and some tests, e.g.,
	**  t-smtp-retry.sh: make the tests more robust against timing changes?)
	*/

	delay = evthr_time(qmgr_ctx->qmgr_ev_ctx) - aq_rcpt->aqr_st_time;

	/* Permanent failures get delayed longer since a bounce is sent */
	if (AQR_IS_FLAG(aq_rcpt, AQR_FL_PERM))
		delay <<= 1;
	if (delay > qmgr_ctx->qmgr_cnf.q_cnf_max_delay)
		delay = qmgr_ctx->qmgr_cnf.q_cnf_max_delay;

	/* no else in case some bozo sets min > max */
	if (delay < qmgr_ctx->qmgr_cnf.q_cnf_min_delay)
		delay = qmgr_ctx->qmgr_cnf.q_cnf_min_delay;

#else /* SM_SIMPLER_DELAY */
	ntries = aq_rcpt->aqr_tries;

	/* Permanent failures get delayed longer since a bounce is sent */
	if (AQR_IS_FLAG(aq_rcpt, AQR_FL_PERM))
		++ntries;

	/* Simple check (broken if q_cnf_delay is outside default range) */
	if (ntries < MAX_SHIFT_TRY)
	{
		/* exponential delay */
		delay = qmgr_ctx->qmgr_cnf.q_cnf_min_delay << ntries;

		/* check whether max reached or arithmetic overflow happened */
		if (delay > qmgr_ctx->qmgr_cnf.q_cnf_max_delay ||
		    delay < qmgr_ctx->qmgr_cnf.q_cnf_min_delay)
			delay = qmgr_ctx->qmgr_cnf.q_cnf_max_delay;
	}
	else
			delay = qmgr_ctx->qmgr_cnf.q_cnf_max_delay;
#endif /* SM_SIMPLER_DELAY */

	QM_LEV_DPRINTFC(QDC_UPDRCPT, 6, (QM_DEBFP, "sev=DBG, func=qm_delay_next_try, aq_rcpt=%p, ntries=%d, cnf_delay=%d, delay=%u\n", aq_rcpt, aq_rcpt->aqr_tries, qmgr_ctx->qmgr_cnf.q_cnf_min_delay, delay));
	sm_log_write(qmgr_ctx->qmgr_lctx,
		QM_LCAT_SCHED, QM_LMOD_SCHED,
		SM_LOG_DEBUG, 15,
		"sev=DBG, func=qm_delay_next_try, aq_rcpt=%p, ntries=%d, cnf_delay=%d, delay=%u",
		aq_rcpt, aq_rcpt->aqr_tries,
		qmgr_ctx->qmgr_cnf.q_cnf_min_delay, delay);
	return delay;
}
