/*
 * Copyright (c) 2002-2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: qm_sc.c,v 1.30 2005/02/02 00:22:32 ca Exp $")
#include "sm/error.h"
#include "sm/assert.h"
#include "sm/io.h"
#include "sm/rcb.h"
#include "sm/qmgr.h"
#include "sm/qmgr-int.h"
#include "sm/rcbcomm.h"
#include "qmgr.h"
#include "log.h"

/*
**  QMGR_SMTPC -- QMGR - SMTPC interface
**	This runs as a task.
**
**	Parameters:
**		tsk -- evthr task
**
**	Returns:
**		usual sm_error code
**
**	Last code review: 2003-10-17 16:12:46, see below
*/

sm_ret_T
qmgr_smtpc(sm_evthr_task_P tsk)
{
	sm_ret_T ret;

	SM_IS_EVTHR_TSK(tsk);
	QM_LEV_DPRINTFC(QDC_Q2C, 5, (QM_DEBFP, "func=qmgr_smtpc, fd=%d, ev=%#x\n", tsk->evthr_t_fd, evthr_rqevents(tsk)));
	if (is_valid_fd(tsk->evthr_t_fd))
	{
		ret = EVTHR_WAITQ;
		if (evthr_got_wr(tsk))
		{
			ret = qm_to_sc(tsk); /* XXX check ret here? */
			if (sm_is_err(ret))
				QM_LEV_DPRINTFC(QDC_Q2C, 1, (QM_DEBFP, "sev=ERROR, func=qmgr_smtpc, qm_to_sc=%r\n", ret));
		}
		if (evthr_got_rd(tsk))
		{
			ret = qm_fr_sc(tsk);
			if (sm_is_err(ret))
				QM_LEV_DPRINTFC(QDC_Q2C, 1, (QM_DEBFP, "sev=ERROR, func=qmgr_smtpc, qm_fr_sc=%r\n", ret));
		}
		return ret;
	}
	return EVTHR_DEL;
}
