/*
 * Copyright (c) 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: init_ali_lfl.c,v 1.5 2005/08/11 17:48:20 ca Exp $")
#include "sm/error.h"
#include "sm/assert.h"
#include "smar.h"
#include "sm/smardef.h"

/*
**  SMAR_INIT_MAP_LFL -- initialize SMAR map lookup flags (aliases/lum)
**	(after reading configuration)
**
**	Parameters:
**		smar_ctx -- SMAR context
**		lfl_conf -- lookup flags from configuration
**		plflags -- (pointer to) lookup flags for smar_ctx (output)
**
**	Returns:
**		SM_SUCCESS
**
**	Can we do this simpler, e.g., a 1-1 mapping?
*/

typedef struct ali_map_fl_S	ali_map_fl_T;
struct ali_map_fl_S
{
	uint32_t amf_smarcnf_fl;
	uint32_t amf_map_fl;
};
static ali_map_fl_T
ali_map_fl[] =
{
	{ SMARCNF_FL_ALI_DETPLUS,	SMMAP_LFL_DETPLUS	},
	{ SMARCNF_FL_ALI_DETSTAR,	SMMAP_LFL_DETSTAR	},
	{ SMARCNF_FL_ALI_STAR,		SMMAP_LFL_STAR		},
	{ SMARCNF_FL_ALI_DOMAIN,	SMMAP_LFL_DOMAIN	},
	{ SMARCNF_FL_ALI_DOTSUBDOM,	SMMAP_LFL_DOTSUBDOM	},
	{ SMARCNF_FL_ALI_IMPLDET,	SMMAP_LFL_IMPLDET	},
	{ SMARCNF_FL_ALI_MREPL,		SMMAP_LFL_MCR_REPL	},
};

sm_ret_T
smar_init_map_lfl(smar_ctx_P smar_ctx, uint lfl_conf, uint *plflags)
{
	uint u, lflags;

	SM_REQUIRE(smar_ctx != NULL);
	SM_REQUIRE(plflags != NULL);

	/* translate configuration flags into map lookup flags */
	lflags = SMMAP_LFL_ALIAS;
	for (u = 0; u < SM_ARRAY_SIZE(ali_map_fl); u++)
	{
		uint32_t map_fl;

		map_fl = ali_map_fl[u].amf_map_fl;
		if (SM_IS_FLAG(lfl_conf, ali_map_fl[u].amf_smarcnf_fl))
			lflags |= map_fl;
		else
			lflags &= ~map_fl;
	}
	*plflags = lflags;
	return SM_SUCCESS;
}
