#!/bin/sh
# $Id: t-archk-0.sh,v 1.24 2005/10/05 23:17:47 ca Exp $
# Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ------------------------------------------------------------
# Description:
# Script to test alias resolution to get rejections (or ok).
# Uses smar, t-smar-2, "aliases" map, t-mm, startsmar.sh
# ------------------------------------------------------------
#
test -s stop && exit 1
#

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../smar
fi
. ${SD}/common.sh

# path to programs
OUT=archk-0.out
RES=archk-0.ip
OK=archk-0.ok
TPRG=./t-smar-2
VERBOSE=false

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

killit()
{
if test -s ${PIDS}
then
  # stop MTA components
  for i in `cat ${PIDS}`
  do
    kill ${i}
  done
fi
# ----------------
# thanks kids for not following the POSIX standard...
if test X"`uname`" = "XLinux"
then
  killall smar
fi
exit 1
}

# create map for smar
rm -f ${ALIMAP}
${MM} <<EOF
ok:	ok
postmaster:	ok
temp:	error:451
perm5:	error:550
perm:	error:
error:	error:6
OpenBSD+ports: ok+openbsd_ports
EOF
if test $? -ne 0
then
  echo t-mm failed
  exit 1
fi

rm -f ${SOCK} ${PIDS}
trap killit 1 2 3
rm -f ${MT} ${MTMAP} ${MTMAPDB}
# start SMAR (creates mt: local.dom is local!)
${SHELL} ${SD}/startsmar.sh || exit 1
rm -f ${OUT} ${RES} ${OK}

TEST=1
# ----------------------------------------
${VALGRIND} ${TPRG} -VVV '<no@local.dom>' > ${OUT} 2>&1
grep '^status=' ${OUT} > ${RES}
cat > ${OK} <<EOF
status=550
EOF
if diff ${OK} ${RES}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && killit
fi

TEST=2
# ----------------------------------------
${VALGRIND} ${TPRG} -VVV '<ok@b.d>' > ${OUT} 2>&1
grep '^status=' ${OUT} > ${RES}
cat > ${OK} <<EOF
status=${SMAR_DFLT_RES}
EOF
if diff ${OK} ${RES}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && killit
fi

TEST=3
# ----------------------------------------
${VALGRIND} ${TPRG} -VVV '<ok@local.dom>' '<postmaster@local.dom>' > ${OUT} 2>&1
grep '^status=' ${OUT} > ${RES}
cat > ${OK} <<EOF
status=${SMAR_DFLT_RES}
status=${SMAR_DFLT_RES}
EOF
if diff ${OK} ${RES}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && killit
fi

TEST=4
# ----------------------------------------
${VALGRIND} ${TPRG} -VVV '<temp@local.dom>' '<perm@local.dom>' '<perm5@local.dom>' > ${OUT} 2>&1
grep '^status=' ${OUT} > ${RES}
cat > ${OK} <<EOF
status=450
status=550
status=550
EOF
if diff ${OK} ${RES}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && killit
fi

TEST=5
# ----------------------------------------
${VALGRIND} ${TPRG} -VVV '<error@local.dom>' > ${OUT} 2>&1
grep '^status=' ${OUT} > ${RES}
cat > ${OK} <<EOF
status=550
EOF
if diff ${OK} ${RES}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && killit
fi

TEST=6
# ----------------------------------------
${VALGRIND} ${TPRG} -VVV '<OpenBSD+ports@local.dom>' > ${OUT} 2>&1
grep '^status=' ${OUT} > ${RES}
cat > ${OK} <<EOF
status=${SMAR_DFLT_RES}
EOF
if diff ${OK} ${RES}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && killit
fi


# stop SMAR
for i in `cat ${PIDS}`
do
  kill ${i}
done
# ----------------
# thanks kids for not following the POSIX standard...
if test X"`uname`" = "XLinux"
then
  killall smar
fi

exit ${ERRS}
