<JSB>
/*
 * Cursor.jsb    1.0 97/08/28
 *
 * Copyright (c) 1997 Netscape Communications Corporation
 *
 * Netscape grants you a non-exclusive, royalty free, license to use,
 * modify and redistribute this software in source and binary code form,
 * provided that i) this copyright notice and license appear on all copies of
 * the software; and ii) Licensee does not utilize the software in a manner
 * which is disparaging to Netscape.
 *
 * This software is provided "AS IS," without a warranty of any kind.
 * See the CDK License Agreement for additional terms and conditions.
 */
     <JSB_DESCRIPTOR NAME="netscape.peas.Cursor" DISPLAYNAME="LiveWire Cursor"
        SHORTDESCRIPTION="LiveWire Database Cursor (server-side)"
        ISHIDDEN ENV="server">

    <JSB_PROPERTY NAME="dbpool" DISPLAYNAME="DBPool" PROPTYPE="JS" TYPE="string"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Name of DBPool to use">

    <JSB_PROPERTY NAME="SQL" DISPLAYNAME="SQL Query" ISRUNTIME PROPTYPE="JS-expr" TYPE="SQLQuery"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="SQL query that defines cursor">

    <JSB_PROPERTY NAME="filterCol" DISPLAYNAME="Filter Column" ISRUNTIME PROPTYPE="JS-expr" TYPE="string"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Name of column to filter on by value passed in request object">

    <JSB_PROPERTY NAME="sortCol" DISPLAYNAME="Sort Column" ISRUNTIME PROPTYPE="JS-expr" TYPE="string"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Column to sort data on">

    <JSB_PROPERTY NAME="sortAscending" DISPLAYNAME="Sort direction" ISRUNTIME PROPTYPE="JS-expr" TYPE="boolean"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Sort direction: TRUE = Ascending; FALSE = Descending">

    <JSB_PROPERTY NAME="updatable" DISPLAYNAME="Updatable" ISRUNTIME PROPTYPE="JS" TYPE="boolean"
        READMETHOD="" WRITEMETHOD=""
        SHORTDESCRIPTION="Specifies if cursor is updatable">

    <JSB_METHOD NAME="close" TYPE="void"> </JSB_METHOD>

    <JSB_METHOD NAME="insertRow" DISPLAYNAME="Insert Row"
        SHORTDESCRIPTION="Insert a new row at the current position"
        TYPE="string">
        <JSB_PARAMETER NAME="tableName" TYPE="string">
    </JSB_METHOD>

    <JSB_METHOD NAME="updateRow" TYPE="string">
        <JSB_PARAMETER NAME="tableName" TYPE="string">
    </JSB_METHOD>

    <JSB_METHOD NAME="deleteRow" TYPE="string">
        <JSB_PARAMETER NAME="tableName" TYPE="string">
    </JSB_METHOD>

    <JSB_METHOD NAME="next" TYPE="boolean"> </JSB_METHOD>

    <JSB_METHOD NAME="columnName" TYPE="string">
        <JSB_PARAMETER NAME="colNumber" TYPE="number">
    </JSB_METHOD>

    <JSB_METHOD NAME="columns" TYPE="Int"> </JSB_METHOD>

    <JSB_CONSTRUCTOR>
function ES2next() {
    result = this.cs.next()
    for (prop in this.cs) {
       this[prop] = this.cs[prop]
    }
    return result
}

function ES2columns() {
    return this.cs.columns()
}

function ES2columnName(n) {
    return this.cs.columnName(n)
}

function ES2close() {
    return this.cs.close()
}

function isSet(val) {
  if ( (val != null) && (val != "") )
     return true
  else
     return false
}

function addWhereCondition( sSQL, sCondition ) {
    sTempSQL = sSQL.toUpperCase()
    var sInsert
    i = sTempSQL.indexOf( "WHERE" )
    if ( i != -1  ) {
        // where clause exists
        sInsert = sCondition + " AND";
        i = i + 6;
    } else {
        // no where... need to add it also
        sInsert = "WHERE " + sCondition;
        i = sTempSQL.indexOf( "GROUP BY" );
        if ( i == -1 ) {
            i = sTempSQL.indexOf( "HAVING" );
            if ( i == -1 ) {
                i = sTempSQL.indexOf( "ORDER BY" );
            }
        }
        if ( i == -1 ) {
            // it goes at end
            return sSQL + " " + sInsert;
        }
    }
    return sSQL.substring( 0, i ) + sInsert + " " + sSQL.substring( i, sSQL.length );
}

function addOrdering( sSQL, sOrdering ) {
    sTempSQL = sSQL.toUpperCase()
    var sInsert
    i = sTempSQL.indexOf( "ORDER BY" )
    if ( i != -1  ) {
        // order by clause exists
        sInsert = sOrdering + ",";
        i = i + 9;
    } else {
        // need to add order by.  Insert at end.
        sInsert = "ORDER BY " + sOrdering;
        return sSQL + " " + sInsert;
    }
    return sSQL.substring( 0, i ) + sInsert + " " + sSQL.substring( i, sSQL.length )
}

function netscape_peas_Cursor(params) {
   if ( !isSet(params.updatable) )
      params.updatable = false

   if ( isSet(params.filterCol) ) {
      sWhereCondition = params.filterCol + " = '" + unescape(request[params.filterCol]) + "'"
      params.SQL = addWhereCondition( params.SQL, sWhereCondition )
      //params.SQL = params.SQL + " WHERE " + params.filterCol + " = '" + unescape(request[params.filterCol]) + "'"
   }

   if ( isSet(request.__sort) ) { // If sorting specified in request, use it regardless
      sOrdering = unescape(request.__sort)
      if ( params.sortAscending == false )
         sOrdering += " DESC"
      params.SQL = addOrdering( params.SQL, sOrdering )

   } else if (isSet(params.sortCol) ) {  // If no sorting specified in request, use sortCol param for sorting
      sOrdering =  params.sortCol
      if ( params.sortAscending == false )
         sOrdering += " DESC"
      params.SQL = addOrdering( params.SQL, sOrdering )
   }

   // ----- Server 2.0 -----
   if (server.httpdlwVersion.indexOf("1.0") != -1) {
       this.cs = database.cursor(params.SQL, params.updatable)
       for (prop in this.cs) {
          this[prop] = this.cs[prop]
       }
       this.next = ES2next
       this.columns = ES2columns
       this.columnName = ES2columnName
       this.close = ES2close
       return this

   // ----- Server 3.0 -----
   } else {
      if (params.dbpool == null) {
         debug("Cursor's DBPool property is null - using generic database object.")
         cursorObj = database.cursor(params.SQL, params.updatable)
      } else {
          pool = project[params.dbpool]
          if (request.connection == null)
             request.connection = pool.connection(pool.id, pool.timeout)
          cursorObj = request.connection.cursor(params.SQL, params.updatable)
          cursorObj.DBConnection = request.connection
      }
   }
   return cursorObj
} // netscape_peas_Cursor
    </JSB_CONSTRUCTOR>
</JSB>
